/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search;

import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilter;
import org.opensearch.action.support.ActionFilterChain;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.neuralsearch.query.HybridQueryBuilder;
import org.opensearch.tasks.Task;

public class HybridQuerySearchRequestFilter
implements ActionFilter {
    @Generated
    private static final Logger log = LogManager.getLogger(HybridQuerySearchRequestFilter.class);
    private static final int DISABLE_BATCHED_REDUCE = Integer.MAX_VALUE;

    public int order() {
        return 0;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        SearchRequest searchRequest;
        if ("indices:data/read/search".equals(action) && request instanceof SearchRequest && this.containsHybridQuery(searchRequest = (SearchRequest)request) && searchRequest.getBatchedReduceSize() != Integer.MAX_VALUE) {
            log.debug(String.format(Locale.ROOT, "Hybrid query detected, disabling batched reduction to prevent 'topDocs already consumed' error. Original batched_reduce_size: %d, new value: %d. Note: batched_reduce_size is not honored for hybrid queries.", searchRequest.getBatchedReduceSize(), Integer.MAX_VALUE));
            searchRequest.setBatchedReduceSize(Integer.MAX_VALUE);
        }
        chain.proceed(task, action, request, listener);
    }

    private boolean containsHybridQuery(SearchRequest searchRequest) {
        if (Objects.isNull(searchRequest.source())) {
            return false;
        }
        QueryBuilder query = searchRequest.source().query();
        if (Objects.isNull(query)) {
            return false;
        }
        return query instanceof HybridQueryBuilder;
    }
}

