/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.util;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpDeserializerBase;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.util.ByteArrayBinaryData;
import org.opensearch.client.util.NoCopyByteArrayOutputStream;

@JsonpDeserializable
public interface BinaryData
extends JsonpSerializable {
    public static final JsonpDeserializer<BinaryData> _DESERIALIZER = new JsonpDeserializerBase<BinaryData>(ByteArrayBinaryData._DESERIALIZER.acceptedEvents()){

        @Override
        public BinaryData deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            return ByteArrayBinaryData._DESERIALIZER.deserialize(parser, mapper, event);
        }
    };

    public String contentType();

    public void writeTo(OutputStream var1) throws IOException;

    public ByteBuffer asByteBuffer() throws IOException;

    public InputStream asInputStream() throws IOException;

    public boolean isRepeatable();

    public long size();

    public static BinaryData of(Object value, JsonpMapper mapper) {
        if (value == null) {
            return null;
        }
        if (value instanceof BinaryData) {
            return (BinaryData)value;
        }
        NoCopyByteArrayOutputStream out = new NoCopyByteArrayOutputStream();
        try (JsonGenerator generator = mapper.jsonProvider().createGenerator((OutputStream)out);){
            mapper.serialize(value, generator);
        }
        return new ByteArrayBinaryData(out.array(), 0, out.size(), "application/json");
    }

    public static BinaryData of(byte[] bytes, String contentType) {
        return new ByteArrayBinaryData(bytes, 0, bytes.length, contentType);
    }

    public static BinaryData of(byte[] value, int offset, int length, String contentType) {
        return new ByteArrayBinaryData(value, offset, length, contentType);
    }
}

