/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import reactor.netty.http.HttpConnectionLiveness;

public final class IdleTimeoutHandler
extends IdleStateHandler {
    private final HttpConnectionLiveness httpConnectionLiveness;

    private IdleTimeoutHandler(long idleTimeout, HttpConnectionLiveness httpConnectionLiveness) {
        super(0L, 0L, idleTimeout, TimeUnit.MILLISECONDS);
        this.httpConnectionLiveness = httpConnectionLiveness;
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) {
        if (evt.state() == IdleState.ALL_IDLE) {
            this.httpConnectionLiveness.check(ctx);
        }
        ctx.fireUserEventTriggered((Object)evt);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.httpConnectionLiveness.receive(msg);
        super.channelRead(ctx, msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.httpConnectionLiveness.cancel();
        super.channelInactive(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.httpConnectionLiveness.cancel();
        super.handlerRemoved(ctx);
    }

    public static void addIdleTimeoutHandler(ChannelPipeline pipeline, @Nullable Duration idleTimeout, HttpConnectionLiveness httpConnectionLiveness) {
        if (idleTimeout != null && pipeline.get("reactor.left.idleTimeoutHandler") == null) {
            String baseName = null;
            if (pipeline.get("reactor.left.httpCodec") != null) {
                baseName = "reactor.left.httpCodec";
            } else {
                ChannelHandler http2FrameCodec = pipeline.get(Http2FrameCodec.class);
                if (http2FrameCodec != null) {
                    baseName = pipeline.context(http2FrameCodec).name();
                } else {
                    ChannelHandler httpServerUpgradeHandler = pipeline.get(HttpServerUpgradeHandler.class);
                    if (httpServerUpgradeHandler != null) {
                        baseName = pipeline.context(httpServerUpgradeHandler).name();
                    } else {
                        ChannelHandler httpServerCodec = pipeline.get(HttpServerCodec.class);
                        if (httpServerCodec != null) {
                            baseName = pipeline.context(httpServerCodec).name();
                        }
                    }
                }
            }
            pipeline.addAfter(baseName, "reactor.left.idleTimeoutHandler", (ChannelHandler)new IdleTimeoutHandler(idleTimeout.toMillis(), httpConnectionLiveness));
        }
    }

    public static void removeIdleTimeoutHandler(ChannelPipeline pipeline) {
        if (pipeline.get("reactor.left.idleTimeoutHandler") != null) {
            pipeline.remove("reactor.left.idleTimeoutHandler");
        }
    }
}

