/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import java.io.Closeable;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.concurrent.RefCountedReleasable;
import org.opensearch.repositories.s3.AmazonAsyncS3WithCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class AmazonAsyncS3Reference
extends RefCountedReleasable<AmazonAsyncS3WithCredentials> {
    private static final Logger logger = LogManager.getLogger(AmazonAsyncS3Reference.class);

    AmazonAsyncS3Reference(AmazonAsyncS3WithCredentials client) {
        super("AWS_S3_CLIENT", (Object)client, () -> {
            client.client().close();
            client.priorityClient().close();
            client.urgentClient().close();
            AwsCredentialsProvider credentials = client.credentials();
            if (credentials instanceof Closeable) {
                Closeable closeable = (Closeable)credentials;
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    logger.error("Exception while closing AwsCredentialsProvider", (Throwable)e);
                }
            }
        });
    }
}

