/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.theme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.infonode.gui.GraphicsUtil;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.TabbedUIDefaults;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.tabbedpanel.border.OpenContentBorder;
import net.infonode.tabbedpanel.internal.TwoColoredLineBorder;
import net.infonode.tabbedpanel.theme.TabbedPanelTitledTabTheme;
import net.infonode.tabbedpanel.titledtab.TitledTabBorderSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.util.Direction;

public class ClassicTheme
extends TabbedPanelTitledTabTheme {
    private TabbedPanelProperties tabbedPanelProperties = new TabbedPanelProperties();
    private TitledTabProperties titledTabProperties = new TitledTabProperties();
    private ColorProvider highlightColor = UIManagerColorProvider.TABBED_PANE_HIGHLIGHT;
    private ColorProvider shadowColor = UIManagerColorProvider.TABBED_PANE_SHADOW;
    private ColorProvider darkShadow = UIManagerColorProvider.TABBED_PANE_DARK_SHADOW;
    private int raised;
    private Border shadowBorder;

    public ClassicTheme() {
        this(2);
    }

    public ClassicTheme(int raised) {
        this.raised = raised;
        this.shadowBorder = new Border(){

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                TabbedPanel tp = TabbedUtils.getParentTabbedPanel(c);
                if (tp != null) {
                    Direction d = tp.getProperties().getTabAreaOrientation();
                    g.setColor(ClassicTheme.this.shadowColor.getColor());
                    if (d == Direction.UP || d == Direction.DOWN) {
                        GraphicsUtil.drawOptimizedLine(g, x + width - 1, y, x + width - 1, y + height - 1);
                    } else {
                        GraphicsUtil.drawOptimizedLine(g, x, y + height - 1, x + width - 1, y + height - 1);
                    }
                }
            }

            @Override
            public Insets getBorderInsets(Component c) {
                TabbedPanel tp = TabbedUtils.getParentTabbedPanel(c);
                if (tp != null) {
                    Direction d = tp.getProperties().getTabAreaOrientation();
                    return new Insets(0, 0, d == Direction.LEFT || d == Direction.RIGHT ? 1 : 0, d == Direction.UP || d == Direction.DOWN ? 1 : 0);
                }
                return new Insets(0, 0, 0, 0);
            }
        };
        CompoundBorder contentBorder = new CompoundBorder(new OpenContentBorder(this.highlightColor, this.darkShadow, null, 1), new OpenContentBorder(null, this.shadowColor, null, 1));
        this.tabbedPanelProperties.getContentPanelProperties().getComponentProperties().setBorder(contentBorder).setInsets(new Insets(1, 1, 1, 1));
        this.tabbedPanelProperties.setTabSpacing(-raised - 1).setShadowEnabled(false);
        this.tabbedPanelProperties.getTabAreaComponentsProperties().getComponentProperties().setBorder(this.doCreateTabBorder(false, false, true, true));
        Border normalBorder = this.createInsetsTabBorder(true, true, false);
        Border highlightBorder = this.doCreateTabBorder(true, true, true, false);
        Insets normalInsets = new Insets(0, 3, 0, 3);
        Insets highlightInsets = new Insets(0, (raised + 1) / 2 + ((raised + 1 & 1) == 1 ? 1 : 0) + normalInsets.left, 1, (raised + 1) / 2 + normalInsets.right);
        this.titledTabProperties.setHighlightedRaised(raised).setBorderSizePolicy(TitledTabBorderSizePolicy.INDIVIDUAL_SIZE);
        this.titledTabProperties.getNormalProperties().getComponentProperties().setBorder(normalBorder).setInsets(normalInsets);
        this.titledTabProperties.getHighlightedProperties().getComponentProperties().setBorder(highlightBorder).setInsets(highlightInsets);
    }

    @Override
    public String getName() {
        return "Classic Theme";
    }

    @Override
    public TabbedPanelProperties getTabbedPanelProperties() {
        return this.tabbedPanelProperties;
    }

    @Override
    public TitledTabProperties getTitledTabProperties() {
        return this.titledTabProperties;
    }

    public Border createInsetsTabBorder(boolean roundEdges, boolean open, boolean highlight) {
        Border insetsBorder = new Border(){

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            }

            @Override
            public Insets getBorderInsets(Component c) {
                TabbedPanel tp = TabbedUtils.getParentTabbedPanel(c);
                if (tp != null) {
                    Direction d = tp.getProperties().getTabAreaOrientation();
                    return new Insets(d == Direction.RIGHT || d == Direction.LEFT ? ClassicTheme.this.raised : 0, d == Direction.UP || d == Direction.DOWN ? ClassicTheme.this.raised : 0, d == Direction.RIGHT || d == Direction.LEFT ? 1 : 0, d == Direction.UP || d == Direction.DOWN ? 1 : 0);
                }
                return new Insets(0, 0, 0, 0);
            }
        };
        return new CompoundBorder(insetsBorder, this.doCreateTabBorder(roundEdges, open, highlight, true));
    }

    public Border createTabBorder(boolean roundEdges, boolean open, boolean highlight) {
        return this.doCreateTabBorder(roundEdges, open, true, highlight);
    }

    private ColorProvider createNormalHighlightColorProvider() {
        return new ColorProvider(){

            @Override
            public Color getColor() {
                Color highlightBackground = TabbedUIDefaults.getHighlightedStateBackground();
                highlightBackground = new Color(highlightBackground.getRed() == 0 ? 1 : highlightBackground.getRed(), highlightBackground.getGreen() == 0 ? 1 : highlightBackground.getGreen(), highlightBackground.getBlue() == 0 ? 1 : highlightBackground.getBlue());
                Color normalBackgroundColor = TabbedUIDefaults.getNormalStateBackground();
                Color color = ClassicTheme.this.highlightColor.getColor();
                int r = (int)((float)normalBackgroundColor.getRed() * ((float)color.getRed() / (float)highlightBackground.getRed()));
                int g = (int)((float)normalBackgroundColor.getGreen() * ((float)color.getGreen() / (float)highlightBackground.getGreen()));
                int b = (int)((float)normalBackgroundColor.getBlue() * ((float)color.getBlue() / (float)highlightBackground.getBlue()));
                r = (r + color.getRed()) / 2;
                g = (g + color.getGreen()) / 2;
                b = (b + color.getBlue()) / 2;
                return new Color(r > 255 ? 255 : r, g > 255 ? 255 : g, b > 255 ? 255 : b);
            }

            @Override
            public Color getColor(Component component) {
                return this.getColor();
            }
        };
    }

    private Border doCreateTabBorder(boolean roundEdges, boolean open, boolean highlight, final boolean equalInset) {
        return new CompoundBorder(new TwoColoredLineBorder(highlight ? this.highlightColor : this.createNormalHighlightColorProvider(), this.darkShadow, roundEdges, open){

            @Override
            protected Insets getShapedBorderInsets(Component c) {
                return equalInset ? new Insets(1, 1, 1, 1) : super.getShapedBorderInsets(c);
            }
        }, this.shadowBorder);
    }
}

