#############################################################################
##
#W  minwordlengthnonbalanced.g        GAP4 Package `RCWA'         Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing a list of
##  smallest lengths of words in the generators of grps[i] which represent
##  non-balanced rcwa permutations. Unbound entries and entries equal to
##  'fail' mean that either the corresponding group contains only balanced
##  elements (this holds of course in particular for all finite groups) or
##  that no non-balanced element in that group has been found so far.
##
#############################################################################

local  minwordlengthnonbalanced, i;

minwordlengthnonbalanced :=
[ ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6, 4,,,,, 4,,,,,,,, 4, 6, 4, 3, 3, 
  2, 2, 2,,,, 3,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,, 6, 4,,,,, 4,,,,,,,, 4, 6, 4,,,,,, 3, 3, 3,, 2, 2, 2,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  6, 4,,,,, 4,,,,,,,, 4, 6, 4,,,,,, 2, 2, 2,, 3, 3, 3,,,,,,,,,,,,,,,,,,,,,,,,,
  ,, 6, 4,,,,, 4,,,,,,,, 4, 6, 4, 2, 2, 3, 3, 3,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,, 6,,,,,,,, 6, 6,,,,,
  ,,,,,,,,,,,,,,,,,, 6,,,,, 6,,,,,,,, 6,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6, 6,,,,,,,,,,,,,
  , 6, 6,,,,,,,,,,,,,,,, 6,,,,,,, 6,,,,,,, 2, 3,,, 2,,,,, 3,,,,,,,,,, 6, 6,,,,
  ,, 2,,, 3,,, 2,,,,, 3,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  6,,,,,,,, 6, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,, 3,,, 2, 
  2, 3,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,, 
  6,,,,,,,,,,,,,,,, 6, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,
  , 3, 3, 2,,,,, 3, 2,,, 3,,,,, 2,, 3,,, 2,,, 3,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,, 6, 6,,,,, 6,,,,,,,, 6, 6, 4,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,
  , 4,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4, 4,,,,,,,,,,,,, 7,,,,,,,, 2, 2, 2,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,, 4, 4,,,,, 6,,,,,,,, 6, 6, 6, 2, 2,,,,,,, 2,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  6,, 6,, 8,,,,, 6,,,,,,,,,,,,,,, 6,,,,, 6,,,,,,,,, 6, 6, 8,, 8, 8,,,,, 8,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,, 6,,,,,,,, 6, 6,,,, 8,, 8, 8,, 8,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,, 6,,,,,,,, 6, 6,,,, 8,, 8, 8,, 8,
  ,,,,,,,,,,,,,,,,,,, 6,, 6,, 6,,,,, 8,,,,,,, 6,,,,, 6,,,,,,,,, 6, 6, 8,, 8, 
  8,,,,, 8,,,,,,, 6,,,, 6,,,,,,,,,, 2,,,, 2,, 4, 4,,,,,, 6,,,, 6,,,,,,,,, 2,,,
  ,,, 2, 4, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,, 10,,,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,, 10,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,, 
  7,,,,,,,,,,,,,, 7,,, 7,,,,,,,, 7,,,,, 7,,,,,,,,,, 7,,,,, 7,,,,,,,,, 6,, 2, 
  7,,,, 2, 6,,,,, 2,,,,,,,, 2,,,, 4, 2,,,,,,, 4, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,, 7,,,,,,,,,,,,, 4, 4,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6, 6,,,,, 6,,,,,,
  ,, 4, 4, 6,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6, 6,,,,, 4,,,,,,,, 6, 6, 6,,,,,, 2, 
  2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,, 4,,,,,,,,,,, 2, 2,,,,,,, 2,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,, 7,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,, 7,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,, 6,,,,, 6,,,,,,,,,,,,,,, 8,,,,,, 6,,, 6, 6,,,,,,,,,,,,,, 6, 6,
  ,, 8, 8,, 8, 8,,,,,,,,,,,,,,,,,,,, 6, 6,, 8,,,,,,, 10,,,,,,,, 6,,,,,, 6,, 6,
  ,,,,, 2,,,, 2,,,,,,,,,,,,,,,, 6, 6,,,,, 2, 6, 7,,, 6, 2,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,, 6,, 6,,,,,, 8,, 8,, 8,, 8,,,
  ,,,,,,,,,,,,,,,,,,,,,,,, 6, 6,,,,,,, 4,,,, 4,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,, 7,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,, 6,,,,,, 8,, 8,, 8,, 8,,,,
  ,,,,,, 6,,,,,, 8,,,, 6, 6,,, 8, 8,, 8, 8,,,,,, 6, 6,, 6,,,,,,, 10,,,,,,,,,, 
  4, 2,,,,, 2,, 4,,,, 2, 4,,,,,,, 2, 4,,,, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,, 4, 4, 
  5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,, 5, 4, 4,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4, 4,,,, 
  2, 2, 2, 5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,, 5, 4, 4, 
  2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,, 10, 7,,,,, 8, 9,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8, 9,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 9,, 8,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,,,, 7,,,,,,,,,,,,,,,,,,,,
  , 7,,,,,, 7,,,,,,,,,,,,,,,,,,,,,,, 7,,,,,, 7,,,,,,,,,,,,,,,,,,,,,,, 2,,,, 2,
  , 3, 3,,,,,,,,,,,,,,,,,,, 2,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,,,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,, 3,,,, 3,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7, 10,,,,, 8, 9,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,, 8,, 9,,,,,,,,,,,,, 9, 8,,,,, 10, 7,,,,,,,, 9, 8,,,
  ,,,,,,,,, 8, 9,,,,, 10, 7,,,,,,,,,,, 2,,,,, 2,,,,,, 2, 3,,,,,,, 2, 3,,, 3, 
  2,,,,,,, 3, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,, 6, 4,,,,, 6,,,,,,,, 6, 6, 4, 4, 6, 2, 2, 2,,,, 6, 6, 6, 4,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,, 6,,
  ,,,,,, 6,, 6,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,, 6,,,,,,,, 6,, 6,,,,,, 2, 2, 
  2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6, 4,,,,, 6,,,,,,,, 6, 6, 4, 2, 2, 6, 4, 
  6, 6, 4, 6, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,, 7,,,,,,,,,,,,,,,,,, 8,,,, 5, 8,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,, 8, 
  6,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,, 8, 6,,,,,,,,,,,,,,, 6, 8,,,,,, 5,,,,,,,,,,,,,,,,,,,,,,
  , 2,,,, 2,,,,,,,,,,,,,,,,,,,,,, 2,,, 6,,, 2,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,, 6,,,,,,,,,,, 6,,, 2, 2, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,,
  ,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,, 2,,, 6, 6, 2,,,,,, 2,,,,,,,, 2,, 6,,, 2,,, 6,,,,, 2,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,, 4, 6,,,,, 6,,,,,,,, 4, 6, 6,,, 2, 2, 2, 4, 6, 6,, 4, 6, 6,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,, 
  6,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6, 4,,,,, 6,,,,,,,, 6, 4, 6, 4, 6, 4, 6, 6, 
  2, 2, 2, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,, 6,, 2, 2,,,,,,, 2,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,, 6, 8,,,,, 8,,,,,,,,,,,, 5,,,, 8,,, 8,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,, 7,, 8,,,,, 8,,,,, 5, 8,,,, 7,,,,, 8,,,,,,
  ,,, 6,, 5, 8,,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,
  , 6, 2,,,, 6,,,,,,,,,,,,,, 8,,,, 2,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  , 7,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,, 7,,,, 8,,,,,, 8,, 8,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8, 6, 8,,, 8,,,,,,,, 
  5, 8,,,, 8,,,,,,, 8, 8,,,,,,,,,, 2,,,,, 2,,,, 6,, 2,,,, 6,,,, 2,,,,, 2,,,,,,
  ,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 3, 3,,,, 2, 2, 2, 3,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,, 3, 3, 3, 2,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8, 8, 8, 
  8, 8, 8,, 8, 8, 8, 8,, 8, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 5,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,, 8, 8, 8,, 8, 8, 8, 8, 8, 8, 8,, 
  8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 5,,,,,,,,,,,,,,,,,
  ,,,,,, 8, 8,, 8, 8, 8,, 8, 8, 8, 8, 8, 8, 8,,,,,,,,,,,,,,,, 8,, 8, 8, 8,, 
  8, 8, 8, 8, 8, 8, 8,, 8,,,,,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,,,,,,,,,,,,, 2,,,
  ,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,, 5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,, 5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7, 10,,,,,,,,,,
  ,,,,,,,,, 5,,,,,,,, 5,,,,,,,,,,, 8, 8, 8, 8, 8, 8,, 8, 8, 8, 8,, 8, 8,,,,,, 
  6, 2,,,,, 2, 6,,,,, 2, 6,,,,,, 6, 2,,,, 6, 2,,,,,, 6,, 2,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,, 6,,,,, 6,,,,,,,, 6,, 6,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,, 3, 3, 3,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,, 2, 2, 2,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,
  ,,, 6,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 3, 8,,,,, 8,,,,,,,, 8, 
  3, 8,,, 2, 2, 2, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4, 3,,,,, 3,,,,,,,, 
  3, 4, 3, 2, 2, 2, 2, 2,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  , 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,, 6, 
  4,,,,, 6,,,,,,,, 6, 6, 4, 6, 6, 2, 2, 2,,,, 6,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,
  ,,,, 4,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,
  ,,,,,,,,,, 6,,,,,,,,,,,,,,, 6,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,, 2, 2, 2,,,,, 4,, 4,,,,,,,,,,, 4,,,,,,,,,,,,,,,, 6,,, 2, 2, 2,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,, 3,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 
  2,,,,,,,,,,,,,,, 4, 6,,,,, 6,,,,,,,, 6, 6, 6,,, 2, 2, 2, 6, 6, 6,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,, 4,,,,,,,,,,,,, 4,,,,, 2, 2, 2,,,,,,
  ,,,,,, 6, 8,,,,, 6,,,,,,,, 3, 6,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,, 3,,,, 
  2, 2, 2,,,,,,,, 8, 6,,,,, 6,,,,,,,,, 6, 3,,, 2, 2, 2,,,,,,,,,,,, 6,,,,,,,,, 
  3, 4, 6,, 2, 2, 2, 2, 2,,,,,,,,, 6, 6,,,,,,,,, 4, 6, 3, 2,, 2, 2, 2,, 2,,,,,
  ,,,, 4,,,,,,,, 4,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,, 4, 4,,,,,,
  ,,,,,, 5,,,, 2, 2, 2,,,,, 8,,, 6,,,,,,,, 6, 4, 6,,, 2, 2, 2, 6, 6, 6,,,,,,, 
  4,, 6,,, 4, 3, 4,,, 2, 2, 2,,, 2, 2,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,
  , 2, 2, 2,,,,,,,,,,,,,, 4,,, 2, 2, 2,,,,,,,,,,, 3,,,,, 2, 2, 2,,,,,,,,,, 5,,
  ,,, 2, 2, 2,,,,,, 6,,,,,,,, 2, 2, 2,,,,,,,,,, 3,,, 2, 2, 2,,,,,,,,,, 3, 3, 
  2, 2, 2, 3,,, 3, 2,,,,,, 2, 2, 2, 3, 3, 3, 3,, 2,, 3, 3, 2, 2, 2,, 3,, 3,,, 
  2,, 2, 2, 2,,,,,,,, 2, 2, 2,,,,,,,, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6, 6,,,,, 
  4,,,,,,,, 4, 6, 6,,, 6, 6, 4, 6, 6, 4,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6, 6,,,,, 4,,,,,,,
  , 4, 6, 6, 6, 6,,,, 2, 2, 2, 4, 4, 6, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,, 
  6,,,,,,,, 6,, 6, 2, 2,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,
  ,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,, 8,,,,, 6,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,,,,,,,,, 8,,,,,,
  ,, 2,,,, 2,,,,,,,,,,,,,,,,,,,,,, 2,,, 6,,, 2,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,, 6, 8,,,,,, 5,,,,, 8,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,, 6,,,,,,,,,,, 6,,, 2, 2, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,, 8,,,,,,,, 7,,,, 5,, 8,,,,,, 8,,,,,,,
  ,,,,,,,,,,,,,,, 8,,,,,,,,,,,,,,,,, 2,,, 6, 6, 2,,,,,, 2,,,,,,,, 2,, 6,,, 2,,
  , 6,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 3, 3, 3,,,,, 2, 2, 2,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,, 2, 2,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  7,,,,,,,, 10,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 5,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8, 8,,,,,,,,,,,,,,,, 8, 8, 8, 8, 8, 8, 
  8,,, 8, 8, 8,,,,,,,,,,,,,,,,,,,,,,,,, 5,,,,,,,,,,,,,,,,,,,,,,, 5,,,,,,,,,,,,
  ,,,,,,, 8,,, 8,,,,,, 6, 2,,,, 2,, 6,,,,,,, 8,,,,,,,, 8,,,,, 2, 6,,,,, 2, 6,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,,,,,,,,,,, 8,, 8, 
  8, 8,, 8, 8, 8, 8, 8, 8,,,,,,,,,,,,,,,,,,,,,,,,, 8,,, 8, 8,,,,, 6,,,,, 6,, 
  2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8, 8, 8, 8, 8,, 8, 8, 8, 8, 8,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,, 5,,,,,,,,,,, 8, 8, 8, 8, 8,, 8, 8, 8, 8, 8,,,,, 8,
  , 8, 8, 8,, 8, 8, 8, 8, 8, 8,,,,,,,,,,, 5,,,,,,,,,,, 2,,,,, 2,,,,,, 2,,,,,,,
  , 2,,,,, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4, 6,,,,, 6,,,,,,,, 6, 6, 4, 6, 4, 
  6, 4, 6,,,, 6, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4, 3,,,,, 3,,,,,,,, 3, 
  4, 3,,,,,, 2, 2, 2,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,, 3, 8,,,,, 8,,,,,,,, 
  8, 3, 8, 2, 2,,,,,,, 2, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 
  2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,, 4,,
  ,,,,,,,,,,,,, 4,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,, 6, 6,,,,, 6,,,,,,,, 6, 4, 
  6, 6, 6,,,,,,, 6, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,
  ,,,,,,,,,, 6,,,,,,,,,,,,,,, 6,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,, 4, 4,,,,,, 2, 2, 2,,,,,,,,,,, 4, 6,,,,, 6,,,,,,,, 6, 6, 6, 6, 6,,,,,,, 
  6, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,, 3,,,,,,,,,,, 2, 2, 2,,,,,,,,, 6,,,,,,,,,
  ,,,,,,,,,,, 6,,,,,, 2, 2, 2,,,,,,,, 4,,,,,,,,,,,,,, 6,,,,,,,,,,,, 2, 2, 2,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,, 4,,,,,,,,,,,,, 4,,,,,,,,,,,, 
  2, 2, 2,,,,,,,,,,,,,,,,,,, 3,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,, 2, 2, 2,,,, 6,,,,,,,,,,,,,,, 5,,,,, 8,,,,, 2, 2, 2,, 6, 6,,,,,,,,,,,,,, 
  3, 6,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,, 3,,,,,,,,,, 2, 2, 2,, 6,,,,,, 6,, 6,
  ,,, 6, 4, 3,, 2,,,, 2,,,, 2, 2, 2, 6,,,,,,,,,,,, 4, 3, 4, 2,,,,,, 2,,, 2, 
  2, 2,,,, 4,,,,,,,, 4, 6, 6,,,,,, 6, 6, 6,, 2, 2, 2,,,,,,,,,,,,,,,,, 4, 4,,,,
  , 2, 2, 2,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2, 6,,,,,,,,, 4,,,,,,,,,,, 2, 2, 2,,, 
  4, 6,,,, 3, 6, 4,,,,,,,, 2, 2, 2, 2, 2,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,
  , 6,,,,,, 2, 2, 2,,,,,,, 4,,,,,,,,,, 2, 2, 2,,,, 3,, 6,,,,,,,,,, 2, 2, 2,,,,
  ,,,,,,,,,,, 2, 2, 2,,, 5,,,,,,,,,,, 2, 2, 2,,, 3,,,,,,,,,, 2, 2, 2,,,,,,, 
  2, 3, 3, 3, 3, 2, 2, 2,, 3, 3, 2,,,, 3,, 3, 2, 2, 2,, 3,, 2,, 3, 3, 3,, 2, 
  2, 2,,,,,,,,, 2, 2, 2,,,,,,,, 2, 2, 2,,,,,,, 2, 2, 2,,,,,, 2, 2, 2,,,,, 2, 
  2, 2,,,, 2, 2, 2,,, 2, 2, 2,, 2, 2, 2, 2, 2, 2, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,, 6,,,,,,,,,,,,,,, 6,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6, 
  6,,,,, 4,,,,,,,, 6, 4, 6, 2, 2,,,, 6, 6, 4, 2, 6, 4, 6,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,, 2,, 6,, 2,,,,,, 6,,,,,,,,,,,,,,,, 2,,,,,, 2,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  , 4,,,,,,,,,,,,,,,,, 4,,,,,,,, 2,,,,, 2,,,,,, 2,,,,, 6, 6,, 2,,,,, 2,,,,,,,
  , 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,, 2, 2, 2, 2,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 
  2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  2, 2, 2,,,,,,,,,,,,,,,,,,,,, 4,,,,,,,,,,,,,,, 4,,,,,, 2, 2, 2,,,,,,,,,,,,,,,
  ,,,, 6, 6,,,,, 6,,,,,,,, 6, 4, 6,,, 6, 6, 6, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,, 4, 4,,,, 2, 2, 2,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,, 6,,,,,,, 2, 
  2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,, 4, 6,,,,, 
  6,,,,,,,, 6, 6, 6,,, 6, 6, 6, 2, 2, 2,,,,,,,,,,,,,,, 5,,,,,,,,,,,,,,, 6,, 6,
  ,,, 2, 2, 2,,,,,,,,,,,,,, 3,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,, 4,,,,,,
  ,,,,,,,, 6,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,,, 2, 2, 2, 4,,,,
  ,,,,,, 4,,,,,,,,,,,,, 4,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 
  2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,, 3,,,,,,,,,,,,,,,,,,,,,, 
  2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,, 5,,,,,,,,,,,,,, 6,,, 8,,,,
  , 2, 2, 2,,,,,, 6,, 6,,,,,,, 3, 6,, 6, 4, 3,, 2, 3, 3, 3, 2, 2, 2,,,, 3, 6,,
  ,,,,,,,, 3,, 4, 3, 4, 2,, 3,,, 2, 2, 2,, 3, 3, 3,,,, 4,,,,,,,, 4, 6, 6,,,,,
  , 2, 2, 2,, 6, 6, 6,,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,, 3,,,,,,,, 6, 8, 6,,,,,
  , 2, 2, 2,,,,, 6,,,,,,,,, 4,,,,,,, 2, 2, 2,,,,,, 3, 4,,,,, 3, 6, 4,,,,, 3, 
  2, 2, 2, 2, 3, 3, 3,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,
  ,,, 4,,,,,, 2, 2, 2,,,,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,,,,,, 2, 2, 2,,,,,, 8, 
  6, 6,,,,,, 2, 2, 2,,,,,,,,,,,,, 2, 2, 2,,,,,,,,,,, 2, 2, 2, 2,, 2,,,,,, 2,,
  , 2, 2, 2,,, 2,,,,, 2,, 2, 2, 2,,,, 2,,,,, 2, 2, 2,,,,,,,, 2, 2, 2,,,,,,, 
  2, 2, 2,,,,,, 2, 2, 2,,,,, 2, 2, 2,,,,, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,, 2,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,, 2, 2,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,, 2,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,, 2, 2,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,
  ,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,, 2,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,, 2,,,,,,,,,,,,,,,,,,, 6, 4,,,,, 6,,,,,,,, 6, 
  6, 4, 2, 2, 6, 6, 6,,,, 2,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,, 4,, 2, 2,,,,,,
  , 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,, 4, 4, 2,,,,,,,,,,,,,,,, 6,,,
  ,,,,,,,,,,,, 6,, 2, 2,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,, 
  2,,,,,,,,,,,,,, 4,,,,,,,,,,,,,,,, 6, 2, 2,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,, 2, 2,,,,,,, 2,,,,,,,,,,,,, 3,,,,, 6,,,,,,,,, 6, 6, 2, 2,,,,,,, 2,,,,,,,
  ,,,, 4, 6,,,,, 6,,,,,,,, 6, 6, 6, 2, 2,,,,,,, 2, 6, 6, 6,,,,,,,,,,,,,,,,,,,,
  ,,,, 2, 2,,,, 4,, 4, 2,,,,,,,,,, 4,,,,,,,,,,,,, 4,,, 2, 2,,,,,,, 2,,,,,,,, 
  5,,,,,,,,,,,,,,,,, 2, 2,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,, 2,,,,,
  , 3,,,,,, 6,,,,,,,, 6, 6,, 2, 2,,,,,,, 2,,,,,,,,,,, 5,,,,,,,, 6,,, 2, 2,,,,
  , 8,, 2,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,, 2,,,,,,,, 6,,,,,, 3,,, 3, 4, 6, 2, 
  2,,, 3, 2,,, 2, 3, 3, 3,,,, 6,,,,,,, 3,, 4, 6, 3, 2, 2, 3, 3, 3,, 2,, 2,,, 
  3,,,, 4,,,,,,,, 4,,, 2, 2,,,,,,, 2,,,,,,,,,,,,,,,,, 2, 2,,,,,,, 2,,,,, 3,,,,
  ,,,,,,, 2, 2,,,,,,, 2,,,, 6,,,,,,,, 6, 4, 6, 2, 2,,,,,,, 2, 6, 6, 6,, 3, 4,,
  ,,, 4, 3, 4, 2, 2, 3, 3, 3,,, 2, 2,, 3,,,,,,,,,,, 2, 2,,,,,,, 2,,,,,,,,,,,, 
  2, 2,,,,,,, 2,,,,,,,,,, 4, 2, 2,,,,,,, 2,,,,,,,, 6,, 2, 2,,,,,, 6, 2,,,,,,,,
  , 2, 2,,,,,,, 2,,,,,,,, 2, 2,,,,,,, 2,,,,, 6,, 2, 2,,,,,, 6, 2,,,,,, 2, 2,,
  , 2,,,, 2, 2,,,, 2, 2, 2,,,,,, 2,, 2,, 2, 2,, 2,,,,, 2,,, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,,,,,, 2,,,,,,,, 2,,,,,,, 2,,,
  ,,, 2,,,,, 2,,,, 2,,,, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,,,,,,,,,,,,, 2,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,, 2,,,,, 2,,,,,, 2,,,,,,,, 2,,,,, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,,,,,,,,,,,,
  , 2,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,,, 2,,,,,, 2,,,,,,,, 2,,,,
  , 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,,,,,,,,,,,,, 2,,,,,, 2,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,,, 2,,,,,, 2,,,,,,,, 2,,,,, 2,,,,,,,, 2,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,,,,,,,,,,,,, 2,,,,,, 
  2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,,, 2,,,,,, 2,,,,,,,, 2,,,,, 2,,,,,,,
  , 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,
  , 2,,,,,,,,,,,,,,,,,,,,,, 2,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,,
  , 2,,,,,, 2,,,,,,,, 2,,,,, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,,,
  ,,,,,,,,,, 2,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,,, 2,,,,,, 2,,,,,
  ,,, 2,,,,, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,, 
  2,,,,,,,,,,,,,,,,,,,,,, 2,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,,, 
  2,,,,,, 2,,,,,,,, 2,,,,, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,,,,,,,,,,,,, 2,,,,,, 2,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,,, 2,,,,,, 2,,,,,,,, 2,,,,, 2,,,,,,,, 
  2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,,,,,,,,,,,,, 2,,,,,, 2,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,,, 2,,,,,, 2,,,,,,,, 2,,,,, 2,,,,,,,, 2,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,,,
  ,,,,,,,,,, 2,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,,,, 2,,,,,, 2,,,,,
  ,,, 2,,,,, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,, 4,, 6,,,,, 4,,,,,,,,,,,,,,, 4,,,,, 4,,,,,,,, 4, 4, 4, 4,, 
  6, 6, 6, 7,,, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4, 4,,,
  ,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,,,,,,,,,,,,,,,,,, 6,,,,,,
  , 4,,,,,,,,,,,,,,,,,, 4,,,,,,, 5,,,,,, 4, 4,,,,, 4,,,,,,,,, 4, 4, 6, 6, 4, 
  4,,,,, 6, 7,,,,,,,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,, 4,,,, 4,,,,,,,,, 2, 4,, 4,
  , 4, 2, 4, 4,,, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,, 4,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,, 5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,, 7,,,,, 7,,,,,,,,,, 7,,,,, 7,,,,,,,,,,, 2,,,,, 2,,,,,, 
  2,,,,,,,, 2,, 4,, 4, 2, 4,, 4,,, 4, 4, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,, 7,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,,,
  ,,,,,,,,,,,,,,, 6,,,,,, 4,,, 4, 4,,,,, 4,,,,,,,,, 4, 4,,, 4, 4,, 6, 6, 6,, 
  7,,,,,,,,,,,,,,,,,, 4,, 5,,,,,,,,,,,,,,,,,,,,,,, 4,,,,,, 2,,,, 2,,,,,,,,, 4,
  ,,,,,, 4, 4,,,,, 2, 6, 6,,, 6, 2, 6, 6,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,, 4,, 4,,,,,,, 6,,,,,,,,,,,,,,,,,,,, 5,,, 4, 4, 4,,, 6, 6, 6, 4, 4,, 
  7,,,,, 4,, 4,,,,,,, 6,,,,,,,,,,, 2,,,,, 2,,,, 4,, 2, 4, 4,, 4,,, 4, 2, 4,,,
  , 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  8, 7,,,,, 8, 8, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4, 5,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,,,,, 7,,,,,,,,,,,
  ,,,,,,,,,,,, 7,,,,,, 7,,,,,,,,,,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,,,,,,,,,,,,, 
  2,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,, 4, 5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,
  ,,,,,,,,,, 5, 4,,,,,,, 5, 4,,,,,,,,,,,, 8, 8,,,, 8, 8, 7,,,,,,,,,,, 2,,,,, 
  2,,,,,, 2, 3,,,,,,, 2, 3,,, 3, 2,,,,,,, 3, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4, 4,,,,, 4,,,,,,,, 4, 4,, 
  6, 6, 4,, 4,,,, 6,,, 7,,,,,,,,, 4,,,,,,,,,,,,,,,,,,,, 6,,,,,,, 4,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,,,,, 5,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,, 7,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,, 4, 4,,,,, 6, 2, 6,,, 2, 6, 
  6, 6,, 6,,,,,,,,,,, 4,,,,,, 2,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,, 4,,,,,,,,,,,,,,,,,,
  ,,,,,,, 4,,, 4,,,,,, 6,,,,,,, 4, 4, 4,,,,,, 4, 4,, 7, 6, 6, 6,,,,,,, 5,,,,,,
  ,,,,, 4,,, 4,,,,,, 6,,,,,,,,,,, 2,,,,, 2,,,,, 6, 2, 6, 6, 6,,,, 6, 2, 6,,,, 
  2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4, 5,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8, 7, 8,,,,, 8, 8,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 5, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,, 8, 8, 7,,,,,, 8, 8,,,,,,,,,,,,,,,,,,,,,,,, 4, 5,,,,,,,
  ,,,,,,,,,,,,,,,, 5, 4,,,,,,,,,,,,,,,,,,,,,,,,,,, 3, 2,,,, 2, 3,,,,,,,,,,,,,,
  ,,,,,,, 2, 3,,,, 3, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,, 7,,,,,,,, 7,,,,,,,, 7,,,,,,,, 7,,,,,,,,,,,,,,,,,,,,,,, 2,,,,, 
  2,,,,,, 2,,,,,,,, 2,,,,, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,,,, 8,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,, 8,,,,,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,, 8,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  7,,,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,,, 7,,,,,,
  ,,,,,,,,,,,,,,,,,, 4, 2,, 4,, 2, 4, 4, 4,,, 4,,,,,,,,,,,,,,,, 2,,,,,, 2,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,, 8,,,,,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,, 7,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,, 7,,,,,,,, 2,,,,, 2,,,,,, 2,,,,,,,, 2,,, 6, 
  6, 2, 6, 6,,,, 6, 6, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  4,,,, 5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,, 7,, 7,, 6,,,,, 6,
  ,,,,,,,,,,,,,,,,,,,,,,, 7,,,,,,,,,,,,,,,,,,,,, 4,,,, 4,,, 2,,,, 2,,,,,,,,,,,
  ,,,,, 4,,,,,, 2, 8,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 5,,,
  ,,,, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,, 7,,,,,,,,,,,,,,,,,,,, 8,,
  ,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,, 8,,,,,,,,,,,,,,, 4,, 6,,,,,
  , 4,,,,,,,,,,,, 7,,,,,, 7,,,,,,, 4, 4,, 6, 6,,,,,,,, 6, 6,,,,,,,, 6,,,,,,,,,
  ,,,, 6,,,,,, 6,,,,,,,,, 5,,, 2,,,,, 2,,,,,, 2,,,,,,,, 2,,,,, 2,, 8, 4, 4,,,
  , 2, 6,,,,, 8,,,,,,,,, 11, 6, 6, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,
  ,,,,,,,,,,,,,,,, 4,,,,,,,,,,,,,,,,,,,, 6,,,,,, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,
  , 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 5, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,, 4,,,,, 4,,,,,,,,, 4, 4, 6,, 6, 6,,,,, 6,,
  ,,,,,,,,,,,,,,,,,,, 2,,,, 2,,,, 4, 4, 8,,,,,,,,,,,,,,, 4, 2,,,,,, 2,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,, 7,,,,,, 7,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,,,,,,,,, 5,,,, 2, 2,,,,,,,,,,,,,,,, 7,,,,,,,
  ,,,,,,,,,,,,, 8,,,,,,,,,,,,,,,,,,, 5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,,
  ,,,, 7,,,,,,,, 7, 7,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,, 8, 2,,,,, 2,,,,,, 2, 8,,,
  ,,,, 2,,,,, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,, 6,,,,, 6, 6, 7,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,, 4, 4,,,,, 4,,,,,,,, 4, 4,,,, 4,, 4, 6, 6, 6,,,, 7,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,,,, 4,,,,,,,, 4, 4, 4, 7,, 6, 6, 6, 4,, 
  4,,,,,,,,,,,,,,,,,,,, 4,,,, 4,,,,, 6,,,,,,,,,,,,,,,,,,,, 4,,, 6,,,,, 4,,,,,,
  ,,,, 4,,,, 4,,,,,,,,, 4, 2,,, 4, 2, 4, 4, 4, 4,,,,,,,,,,,,,,,,,, 2,,,,,, 2,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  , 5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,, 6,,,,,, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,, 7,,,,,,,,,,,,,
  , 7,,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6, 6, 6, 2, 6,,,, 2, 6, 6,,,, 
  2,,,,,,,, 2,,,,, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  7,,,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,, 5,,,
  ,,,,,,,,,,,,,,,,,,,,,,,, 8,,,, 8, 7, 8, 8,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,,,,,,,,,,,,, 2,,,,,, 2,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 5, 4,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8, 8,,,, 8, 8, 7,,,,,,,,,,,,,,,,,,, 4, 5,,,,,,
  ,, 5,, 4,,,,,,,,,,,,,,,,,, 6,,,,,,,,, 3,, 2,,,,, 2, 3,,,,, 2,, 3,,,,, 3, 2,,
  ,,, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,, 8,,,,, 8,,,,,,,,,,,,,,,,,,,,, 8,,,,,, 8,,,,,,,,,,,,,,
  ,,,,,,,,, 8,,,,,, 8,,,,,,,,,,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,,,,,,,,,,,,, 2, 
  4,,, 4, 4, 2, 4, 4, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,, 8,,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,,,, 
  7,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,,,, 7,,,,,,,,,,,,,,,,,,,,,, 4,, 4, 4, 2,, 
  4,,, 2, 4, 4,,,, 2,,,,,,,, 2,,,,, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,,
  ,, 4,,,,,,,, 4, 4,,,, 6,, 6, 6,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,, 6, 6,,,,,,,,,,,,,,,,, 4,,,, 2,,,, 2,,,,,,,,,,,,,,,,,,,,,
  , 2,,,,, 8, 2,,,,,,,,,,,,,,,,,,,,,,, 7,, 7,,,,,,,,,,,,,,,,,,,,,,,,, 5,, 4,,,
  ,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,, 2, 2,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,, 8,,,,,,,,,,,,, 4,,,,,, 6,,, 4,,,,,,,
  ,,,,,,,, 7,, 7,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,,,,,,,,,,,
  , 2,,,,, 2,,,,,, 2,,, 5,,,,, 2,, 4, 8,, 2,,,,, 4,,, 2,,,,, 6, 8,,,,,,,,, 11,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6, 6, 6,,,,,,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,, 4, 5,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,,,,,,,,,,,,, 2,,,,,, 2,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 5,, 4,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  5, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,, 7,,,,,,,,,, 3, 2,,,,, 2,, 3,,,, 2,,,,,,,, 2,,,,, 2, 3,,,,
  , 3,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,, 8,, 8,,,,,,,,,,,,,,,,,,,,,,, 8,,,, 8,,,,,,,,,,,,,,,,,,,
  ,, 4,,,, 2,,,, 2,,,,,,,,,,,,,,,, 7,,,,,, 2,,,,,, 2,,, 8, 4, 4,,,, 4,,,,,,,,,
  ,,,,,, 5,,,,,,,,,,,,,,,,,,,,,,,,, 7,,,,, 7,,,,,,,,,,,,,,,,,,, 8,,,,, 8,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,, 7,,,,,,,,,, 5,,, 2, 2,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,
  ,,,,,,,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,,,, 6,,,,,, 
  6,,,,,,,,,, 7,,,,,,,,,,,,,,,,,,,,,,,,,, 8,,, 2,,,,, 2,,,,,, 2,, 8,,,,,, 2,,,
  ,, 2, 8,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,, 8,, 6,,,,,,, 8,,,,, 11, 6, 
  6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,,,,,, 8,,,,,,,,,,,,,,,,, 4,,,,,, 
  2,,,, 2, 8,,,,,,,,,,,,,,,, 4,,, 4,, 2,,,,,, 2,,,, 8,,,,,,,,,,,,, 4,,,,,,,,, 
  6,, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,,, 8,,,,,,,,,,,,,,,,,
  ,,, 7,,, 7,,,,,,,,,,,,,,,,,,, 8, 2, 2,,,,,,,,,,,,,,,,,,, 5, 4,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,, 4, 4,,
  , 6, 6,, 6, 6,,,,,,,,,,,,,,,, 7,,,,,,, 8, 4,,, 2,,,, 4, 2,,,,,, 2,,,,,,,, 2,
  ,,,, 2,,, 5,,,,, 2,,,,,, 11,,,,,,,,, 8, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,
  ,,, 6, 6,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,,, 8, 2,,,, 2,,,,,,,,,,,,,,,,,,,,, 4, 
  2,,,,,, 2,,,,,,,,,,,,,,,,, 4,,, 6,,,,,,, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,, 8,,,,,,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,,,,,,, 2, 2,,,,,
  ,,,,,,,, 5,,,,,,,, 4,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,,, 7,,,,,,,,, 7,,,,,,,,, 
  7,,,,,,, 7,,,,,,,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,, 7, 7,, 6,,,,,,, 8,,,,,,,,
  ,,, 2, 4, 8, 4,, 2,,,, 5,, 2,,,,,,,, 2,,,,, 2,,,,,,,, 2, 6,,,, 6, 11, 6, 6,,
  ,,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,
  , 2, 2,,,, 2, 2,,,,,,, 4,,,,,, 4,,,,,,,, 2,,,, 2,,,,,,,,,,,,,,,,,,,,, 2,,,, 
  2,, 3, 3,,,,,,, 7,, 4,,,,,,,, 2,,,, 2,,,, 5,,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,
  ,,,,,,,, 2,,,, 2,, 2, 2,,,,,,,,,,,,,, 2,,,, 2,,,,,,,,,,,,,,,, 2,,,, 2,,,, 
  4, 4, 8,,,, 4,,,,, 2,,,, 2,,,,,,,,,,,,,, 2,,,, 2,, 8,,,,,,,, 4,,, 2,,,, 2,,,
  ,,,,,,,,, 2, 5,,, 2,,,,,,,,,,, 2,,,, 2,, 8,,,,,,,, 2,,, 2, 2,,,, 2,,,,, 2, 
  2,,, 2,,,,, 2,,, 2,, 2,, 2,,,,,, 2, 2,,,, 2,,,,,,, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2,,, 2,,,,,,,, 2,,,,,,, 2,,,,,,, 2, 2, 2, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,, 
  4,,,,,,, 2,,,,,, 2,,,,,,,,,,,,,,,,,,, 2,,,,,, 2,,,,,,,,, 7,,,,,,,,, 2,, 4, 
  4, 8,, 2,,,,,,,,,,,,,,,,, 2,,,,,, 2,,,,,,,,,,,,,,,, 2,,,,,, 2, 2, 2,,,,,,,,,
  ,,,, 2,,,,,, 2, 3, 3,,,, 4,,,, 4,,,, 2,,, 5,,, 2,,,,,,,,, 4,,,, 2,,,,,, 2,,,
  ,,,,,,,,, 2,,,,,, 2, 8,,,,,,,,,, 2,,,,,, 2,,,, 5,,,, 4,, 2,,,,,, 2,,,,,,,,, 
  2,,,,,, 2, 8,,,,,,, 2,,,, 2,, 2,,, 2,,,, 2,, 2,,,, 2,,,, 2,, 2,,, 2,,, 2,,,,
  , 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,,,,, 2,,,,,,,,, 2,,,,,,,, 2,,,,,,, 2,,,
  ,,, 2,,,,,, 2, 2, 2, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,,,,,, 4, 
  4, 4, 7,,,,, 4,, 4,, 6, 6, 6,,,,,,,,,,,,,,,,,,,,,,,,,,, 4, 4, 4,,,,, 4, 4,,
  , 4, 4, 4, 2, 2, 4,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,, 7,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,, 4,, 4,,, 7,,, 6, 6, 6,, 4,, 4,,,,,,,,,, 4,,,,,, 6,,,,,,,, 6,,,,
  ,,, 4,,, 4,,,,,,,,,, 5,,,,,,,,, 4, 4, 2,,, 4, 4, 2, 4, 4,,,, 2,,,,,,,, 2,,,,
  , 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,, 7,,,,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 3,,,, 3,
  , 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8, 7, 8,,,,, 8, 8,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,, 4,, 5,,,,,,,,,,,,, 8, 8,,,,, 8, 7, 8,,,,,,, 6,,,,,,,,,,,,,,,
  ,,, 4,, 5,,,,,,,,,,, 2,,,,, 2,,,,,, 2,,,,,,,, 2,,,,, 2,,,,,,,, 2,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 7,,
  , 7,,,,,, 4,,,, 4,,,,,,,,,, 2, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,,,,,
  , 6,,,,,,,,,, 7,,,,,,,,, 7,,,,,, 4,, 4,,,,,, 6,, 6,, 6,, 6,,,,,,,,,,,,,,,, 
  7,,,,,,,,, 6,,,,,,,, 6,,,,,,,,,,, 6,,,,,,,,,,, 2,,,,, 2,,,,,, 2,,,,,,, 8, 2,
  ,,,, 2,,,,,, 8,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,, 6, 8,,,,,,, 6,, 8,,,,, 11,,,,
  ,,,,,,,,,,,,,,,,, 6, 6,,,,,,,,,,,, 6, 6, 6,,, 6, 6, 2, 2,, 6,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,, 7,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8, 8,,,,,,,,
  ,,, 8,,,,,,,, 8,,,,,,,, 8,,,,,,,, 8,,,,,,,,,,,, 8, 8,,,,,,,,,, 2,,,,, 2,,,,,
  , 2, 4, 4,,, 4, 4, 4, 2, 4,,,, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 3,,,,,, 3, 2, 2,,,, 4,,,, 4,,, 4,
  ,,,,,,, 2, 2,,,,, 4, 4, 4,,,, 4, 4,, 4,, 4, 4, 2, 2,,, 4,,,, 4,,,,,,,,,, 2, 
  2,,,,,,,,,,, 8, 4, 4,,, 2, 2,,,,,,,,,,,,,,, 2, 2, 4, 8, 4,,, 4,,,,,,,, 2, 2,
  ,, 8,,,,,,, 2,,, 2, 2, 2,,,,,, 2,,,,, 2, 2,, 2,,,,, 2,,,, 2, 2,,, 2,,,,,,, 
  2, 2,,,,,,,,, 2, 2,,,,,,,, 2, 2,,,,,,, 2, 2,,,,,, 2, 2,,,,, 2, 2,,,, 2, 2,,,
  , 2, 2, 2, 2, 2, 2, 2,,,,,,,,,,,,,,, 7,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,, 4, 5,,,,,,,,,,,,,,,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,, 4, 5,,,,,,,,,,, 2,,
  ,,, 2,,,,,, 2,,,,,,,, 2,,,,, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4, 4, 4, 4,, 6, 6, 6, 7,,, 4,,,,,,,,,,,,
  ,,,,, 6,,,,,,,,,,,,,, 6,,,,, 6,,,,,,,,, 7,,,,,,,,,, 4,, 4,,,, 6, 6,, 6, 6,,,
  ,,,,,,, 8, 2,,,,, 2,,,,,, 2, 8,,,,,,, 2,,,,, 2,,,,, 8,,, 2,,,,,,,,,,,,,,,,,,
  ,,,, 6,,,,,,, 8,, 6,,,,, 6, 6, 11,,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 4,,,,,
  ,,, 5,,,,,,,,,,,,, 4,,,,,,, 6,,,,,,,, 6,,,,,,,,, 4, 4,, 4,,, 7,,, 6, 6, 6,, 
  4,, 4,,,,,,, 2,,,,, 2,,,,,, 2,,,,,,,, 2,,,, 4, 2, 4,,, 4, 4, 4, 4, 2,,,,,,,,
  ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8,,
  , 8,,,,,,,, 8,,,,, 8,,,,,,,,,,,,,,, 8,,,,,,,,,,, 2,,,,, 2,,,, 4, 4, 2,,,,,, 
  8,, 2,,,,, 2,,,, 5,,,, 2,,,,,,, 6,,,,,,,,,, 6,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
  6,,,,, 6,,,,, 7,,,,,,,,,,,,,,,, 8,,,,,,,, 8,,,,,,,,,,,, 8,,, 8,,,,,,,, 2,,,,
  , 2, 8,,,,, 2,,,,,,,, 2,,,,, 2,,,,,,, 8, 2,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 11,,
  ,,,,,, 6, 8,,,,, 8, 6,,,,,,,,,,,,,,,,,,,, 6,, 6,,,,,, 8,,,,, 8,,,,,,,,, 8,, 
  2,,,,, 2,,,,,, 2,,,,,,,, 2,,,, 8, 2,,,,,,,, 2,,,,,,,,,,,,,,,,,,,,,, 6, 6,,,,
  , 6, 11, 6,,,,,,,, 8,,,,, 8,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 2,,, 5,, 2,,,, 4, 
  4, 2,,,,,, 8,, 2,,,,, 2,,,,,,,, 2,,,,,, 8, 6,,,,,,,, 8,, 6,,,,,,,,,,,,,,,,,,
  ,,,,,,,,,,,, 6,,,,, 6,,,,, 11,,,,,,,,,,,,, 2,, 2,,,,, 2, 2,,,,, 2, 2,,,,, 2,
  , 2,,,, 2,,,,, 2,,,,, 2,,,,, 2,,,, 2,,,,, 2,,, 2,,,,, 2,,, 2, 2, 2, 2, 2, 
  2, 2,,,, 2,,,,, 2,,,, 2,,, 2,,, 2, 2,,,, 2, 2,,,,,,, 2, 2,, 2,,,,,,,, 2,, 2,
  ,,,,,,, 2,, 2, 2, 2, 2, 2, 2, 2, 2, 2,,,,,,, 2,,,,,,, 2,,,,,, 2,,,,, 2,,,, 
  2,,, 2,, 2,, 2,,, 2,,,,,,,, 2,, 2,,,,,,,, 2, 2,,,,,,,, 2, 2, 2, 2, 2, 2, 2, 
  2, 2,,,,,,, 2,,,,,, 2,,,,, 2,,,, 2,,, 2,, 2, 2 ];

for i in [1..52394] do
  if not IsBound(minwordlengthnonbalanced[i])
  then minwordlengthnonbalanced[i] := fail; fi;
od;

return minwordlengthnonbalanced;

#############################################################################
##
#E  minwordlengthnonbalanced.g . . . . . . . . . . . . . . . . . .  ends here
