/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.SB;
import jspecview.api.JSVPanel;
import jspecview.api.JSVTreeNode;
import jspecview.common.PanelData;
import jspecview.common.Parameters;
import jspecview.common.Spectrum;
import jspecview.dialog.JSVDialog;
import jspecview.source.JDXSource;

public class PanelNode {
    public JSVTreeNode treeNode;
    public JDXSource source;
    public String fileName;
    public JSVPanel jsvp;
    public String id;
    public JSVDialog legend;
    public boolean isSelected;
    public boolean isView;
    public boolean isSimulation;
    public String frameTitle;

    public PanelNode(String id, String fileName, JDXSource source, JSVPanel jsvp) {
        this.id = id;
        this.source = source;
        this.fileName = fileName;
        this.isSimulation = source.getFilePath().indexOf("http://SIMULATION/") >= 0;
        this.jsvp = jsvp;
        if (jsvp != null) {
            this.pd().getSpectrumAt(0).setId(id);
            this.frameTitle = jsvp.getTitle();
        }
    }

    public void setTreeNode(JSVTreeNode node) {
        this.treeNode = node;
    }

    public Object getTreeNode() {
        return this.treeNode;
    }

    public void dispose() {
        this.source.dispose();
        if (this.jsvp != null) {
            this.jsvp.dispose();
        }
        this.source = null;
        this.jsvp = null;
        this.legend = null;
    }

    public PanelData pd() {
        return this.jsvp.getPanelData();
    }

    public Spectrum getSpectrum() {
        return this.pd().getSpectrum();
    }

    public JSVDialog setLegend(JSVDialog legend) {
        if (this.legend != null) {
            this.legend.dispose();
        }
        this.legend = legend;
        return legend;
    }

    public String toString() {
        return (this.id == null ? "" : this.id + ": ") + (this.frameTitle == null ? this.fileName : this.frameTitle);
    }

    public static JDXSource findSourceByNameOrId(String id, Lst<PanelNode> panelNodes) {
        PanelNode node;
        int i = panelNodes.size();
        while (--i >= 0) {
            node = (PanelNode)panelNodes.get(i);
            if (!id.equals(node.id) && !id.equals(((Spectrum)node.source.getSpectra().get((int)0)).sourceID) && !node.source.matchesFilePath(id)) continue;
            return node.source;
        }
        i = panelNodes.size();
        while (--i >= 0) {
            node = (PanelNode)panelNodes.get(i);
            if (!id.equals(node.fileName)) continue;
            return node.source;
        }
        return null;
    }

    public static PanelNode findNodeById(String id, Lst<PanelNode> panelNodes) {
        if (id != null) {
            int i = panelNodes.size();
            while (--i >= 0) {
                if (!id.equals(((PanelNode)panelNodes.get((int)i)).id) && !id.equals(((PanelNode)panelNodes.get((int)i)).frameTitle)) continue;
                return (PanelNode)panelNodes.get(i);
            }
        }
        return null;
    }

    public static PanelNode findNode(JSVPanel jsvp, Lst<PanelNode> panelNodes) {
        int i = panelNodes.size();
        while (--i >= 0) {
            if (((PanelNode)panelNodes.get((int)i)).jsvp != jsvp) continue;
            return (PanelNode)panelNodes.get(i);
        }
        return null;
    }

    public static String getSpectrumListAsString(Lst<PanelNode> panelNodes) {
        SB sb = new SB();
        for (int i = 0; i < panelNodes.size(); ++i) {
            PanelNode node = (PanelNode)panelNodes.get(i);
            if (node.isView) continue;
            sb.append(" ").append(node.id);
        }
        return sb.toString().trim();
    }

    public static int isOpen(Lst<PanelNode> panelNodes, String filePath) {
        if (filePath != null) {
            int i = panelNodes.size();
            while (--i >= 0) {
                if (!((PanelNode)panelNodes.get((int)i)).source.matchesFilePath(filePath) && !filePath.equals(((PanelNode)panelNodes.get((int)i)).frameTitle)) continue;
                return i;
            }
        }
        return -1;
    }

    public void setFrameTitle(String name) {
        this.frameTitle = name;
    }

    public static JSVPanel getLastFileFirstNode(Lst<PanelNode> panelNodes) {
        int n = panelNodes.size();
        PanelNode node = n == 0 ? null : (PanelNode)panelNodes.get(n - 1);
        int i = n - 1;
        while (--i >= 0 && ((PanelNode)panelNodes.get((int)i)).source == node.source) {
            node = (PanelNode)panelNodes.get(i);
        }
        return node == null ? null : node.jsvp;
    }

    Map<String, Object> getInfo(String key) {
        Map<String, Object> info = this.pd().getInfo(false, key);
        Parameters.putInfo(key, info, "panelId", this.id);
        Parameters.putInfo(key, info, "panelFileName", this.fileName);
        Parameters.putInfo(key, info, "panelSource", this.source.getFilePath());
        return info;
    }
}

