/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sf.juife.EnhancedDialog;
import net.sf.juife.JuifeUtils;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.ClassicPrefs;
import org.jsampler.view.classic.ConsolePane;
import org.jsampler.view.classic.GeneralPane;
import org.jsampler.view.classic.Res;
import org.jsampler.view.classic.ViewPane;
import org.jsampler.view.std.JSConnectionPropsPane;
import org.jsampler.view.std.JSDefaultsPropsPane;

public class PrefsDlg
extends EnhancedDialog {
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final GeneralPane genPane = new GeneralPane(this);
    private final ViewPane viewPane = new ViewPane();
    private final ConsolePane consolePane = new ConsolePane();
    private final JSConnectionPropsPane connectionPane = new JSConnectionPropsPane();
    private final JSDefaultsPropsPane defaultsPane;
    private final JButton btnApply = new JButton(ClassicI18n.i18n.getButtonLabel("apply"));
    private final JButton btnClose = new JButton(ClassicI18n.i18n.getButtonLabel("close"));

    public PrefsDlg(Frame frame) {
        super(frame, ClassicI18n.i18n.getLabel("PrefsDlg"), true);
        this.defaultsPane = new JSDefaultsPropsPane(this, Res.iconEdit16);
        this.initPrefsDlg();
        this.installListeners();
        this.setLocation(JuifeUtils.centerLocation(this, frame));
        int n = ClassicPrefs.preferences().getIntProperty("PrefsDlg.tabIndex");
        if (n >= 0 && n < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(n);
        }
    }

    private void initPrefsDlg() {
        JTabbedPane jTabbedPane = this.tabbedPane;
        jTabbedPane.setTabLayoutPolicy(1);
        jTabbedPane.addTab(ClassicI18n.i18n.getLabel("PrefsDlg.tabGeneral"), this.genPane);
        jTabbedPane.addTab(ClassicI18n.i18n.getLabel("PrefsDlg.tabView"), this.viewPane);
        jTabbedPane.addTab(ClassicI18n.i18n.getLabel("PrefsDlg.tabConsole"), this.consolePane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel.add(this.connectionPane);
        jTabbedPane.addTab(ClassicI18n.i18n.getLabel("PrefsDlg.tabBackend"), jPanel);
        jTabbedPane.addTab(ClassicI18n.i18n.getLabel("PrefsDlg.tabDefaults"), this.defaultsPane);
        jTabbedPane.setAlignmentX(1.0f);
        Dimension dimension = JuifeUtils.getUnionSize((Component)this.btnApply, this.btnClose);
        this.btnApply.setPreferredSize(dimension);
        this.btnClose.setPreferredSize(dimension);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.btnApply);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.btnClose);
        jPanel2.setAlignmentX(1.0f);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jTabbedPane);
        jPanel3.add(Box.createRigidArea(new Dimension(0, 12)));
        jPanel3.add(jPanel2);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(11, 12, 12, 12));
        this.getContentPane().add(jPanel3);
        this.pack();
        this.setResizable(false);
    }

    private void installListeners() {
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsDlg.this.onApply();
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsDlg.this.onExit();
            }
        });
    }

    @Override
    protected void onOk() {
        this.onApply();
    }

    @Override
    protected void onCancel() {
        this.onExit();
    }

    private void onApply() {
        this.genPane.apply();
        this.viewPane.apply();
        this.consolePane.apply();
        this.connectionPane.apply();
        this.defaultsPane.apply();
        ClassicPrefs.preferences().setIntProperty("PrefsDlg.tabIndex", this.tabbedPane.getSelectedIndex());
        this.setVisible(false);
    }

    private void onExit() {
        this.setVisible(false);
    }
}

