/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.juife.OkCancelDialog;
import org.jsampler.CC;
import org.jsampler.view.std.JSGeneralProps;
import org.jsampler.view.std.StdI18n;

public class JSAdvancedGeneralPropsDlg
extends OkCancelDialog {
    private final MainPane mainPane = new MainPane();

    public JSAdvancedGeneralPropsDlg(Dialog dialog) {
        super(dialog, StdI18n.i18n.getLabel("JSAdvancedGeneralPropsDlg.title"));
        this.btnOk.setText(StdI18n.i18n.getButtonLabel("apply"));
        this.setMainPane(this.mainPane);
        this.btnOk.requestFocus();
    }

    @Override
    protected void onOk() {
        if (!this.btnOk.isEnabled()) {
            return;
        }
        this.mainPane.apply();
        this.setVisible(false);
        this.setCancelled(false);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    public static class ExportSettingsPane
    extends JPanel {
        private final JCheckBox checkExportMidiMapsToSession = new JCheckBox(StdI18n.i18n.getLabel("ExportSettingsPane.checkExportMidiMapsToSession"));
        private final JCheckBox checkLoadInstrInBackground = new JCheckBox(StdI18n.i18n.getLabel("ExportSettingsPane.checkLoadInstrInBackground"));

        public ExportSettingsPane() {
            this.setLayout(new BoxLayout(this, 1));
            boolean bl = CC.preferences().getBoolProperty("exportMidiMapsToSessionScript");
            this.checkExportMidiMapsToSession.setSelected(bl);
            this.checkExportMidiMapsToSession.setAlignmentX(0.0f);
            this.add(this.checkExportMidiMapsToSession);
            bl = CC.preferences().getBoolProperty("loadMidiInstrumentsInBackground");
            this.checkLoadInstrInBackground.setSelected(bl);
            this.checkLoadInstrInBackground.setAlignmentX(0.0f);
            this.add(this.checkLoadInstrInBackground);
            String string = StdI18n.i18n.getLabel("ExportSettingsPane.title");
            this.setBorder(BorderFactory.createTitledBorder(string));
            this.setAlignmentX(0.0f);
        }

        protected void apply() {
            boolean bl = this.checkExportMidiMapsToSession.isSelected();
            CC.preferences().setBoolProperty("exportMidiMapsToSessionScript", bl);
            bl = this.checkLoadInstrInBackground.isSelected();
            CC.preferences().setBoolProperty("loadMidiInstrumentsInBackground", bl);
        }
    }

    public static class MidiBankProgramNumberingPane
    extends JPanel {
        private final JLabel lFirstBank = new JLabel(StdI18n.i18n.getLabel("JSAdvancedGeneralPropsDlg.lFirstBank"));
        private final JLabel lFirstProgram = new JLabel(StdI18n.i18n.getLabel("JSAdvancedGeneralPropsDlg.lFirstProgram"));
        private final JComboBox cbFirstBank = new JComboBox();
        private final JComboBox cbFirstProgram = new JComboBox();

        public MidiBankProgramNumberingPane() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagLayout.setConstraints(this.lFirstBank, gridBagConstraints);
            this.add(this.lFirstBank);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.lFirstProgram, gridBagConstraints);
            this.add(this.lFirstProgram);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.cbFirstBank, gridBagConstraints);
            this.add(this.cbFirstBank);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.cbFirstProgram, gridBagConstraints);
            this.add(this.cbFirstProgram);
            String string = StdI18n.i18n.getLabel("MidiBankProgramNumberingPane.title");
            this.setBorder(BorderFactory.createTitledBorder(string));
            this.cbFirstBank.addItem("0");
            this.cbFirstBank.addItem("1");
            this.cbFirstProgram.addItem("0");
            this.cbFirstProgram.addItem("1");
            int n = CC.preferences().getIntProperty("firstMidiBankNumber");
            if (n < 0 || n > 1) {
                n = 1;
            }
            this.cbFirstBank.setSelectedIndex(n);
            n = CC.preferences().getIntProperty("firstMidiProgramNumber");
            if (n < 0 || n > 1) {
                n = 1;
            }
            this.cbFirstProgram.setSelectedIndex(n);
            this.setAlignmentX(0.0f);
        }

        public void apply() {
            int n = this.cbFirstBank.getSelectedIndex();
            if (n < 0) {
                n = 1;
            }
            CC.preferences().setIntProperty("firstMidiBankNumber", n);
            n = this.cbFirstProgram.getSelectedIndex();
            if (n < 0) {
                n = 1;
            }
            CC.preferences().setIntProperty("firstMidiProgramNumber", n);
        }
    }

    public static class MainPane
    extends JPanel {
        private final JSGeneralProps.MaxVolumePane maxVolumePane = new JSGeneralProps.MaxVolumePane();
        private final MidiBankProgramNumberingPane numberingPane = new MidiBankProgramNumberingPane();
        private final ExportSettingsPane exportSettingsPane = new ExportSettingsPane();

        public MainPane() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.maxVolumePane);
            this.add(Box.createRigidArea(new Dimension(0, 6)));
            this.add(this.numberingPane);
            this.add(Box.createRigidArea(new Dimension(0, 6)));
            this.add(this.exportSettingsPane);
        }

        public void apply() {
            this.maxVolumePane.apply();
            this.numberingPane.apply();
            this.exportSettingsPane.apply();
        }
    }
}

