/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.util.Vector;
import org.jsampler.LscpNode;
import org.jsampler.LscpTree;

public class LscpUtils {
    private LscpUtils() {
    }

    public static boolean spellCheck(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        if (string.charAt(0) == '#') {
            return true;
        }
        LscpNode lscpNode = LscpTree.getRoot();
        String[] stringArray = string.split(" ", -20);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i < stringArray.length - 1) {
                if ((lscpNode = LscpUtils.checkCommand(stringArray[i], lscpNode)) == null) {
                    return false;
                }
                if (lscpNode.getChildren().length == 0) {
                    return lscpNode.hasParameters();
                }
            } else {
                return LscpUtils.checkPartialCommand(stringArray[i], lscpNode);
            }
            if (!lscpNode.isEndOfACommand() || !lscpNode.hasParameters()) continue;
            return true;
        }
        return true;
    }

    private static LscpNode checkCommand(String string, LscpNode lscpNode) {
        for (LscpNode lscpNode2 : lscpNode.getChildren()) {
            if (!lscpNode2.getName().equals(string)) continue;
            return lscpNode2;
        }
        return null;
    }

    private static boolean checkPartialCommand(String string, LscpNode lscpNode) {
        for (LscpNode lscpNode2 : lscpNode.getChildren()) {
            if (!lscpNode2.getName().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public static String[] getCompletionPossibilities(String string) {
        String string2 = "";
        LscpNode lscpNode = LscpTree.getRoot();
        String[] stringArray = string.split(" ", -20);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (i < stringArray.length - 1) {
                if (string2.length() > 0) {
                    string2 = string2 + " ";
                }
                string2 = string2 + string3;
                if ((lscpNode = LscpUtils.checkCommand(string3, lscpNode)) == null) {
                    throw new IllegalStateException("Invalid command!");
                }
                if (lscpNode.getChildren().length != 0) continue;
                if (lscpNode.isEndOfACommand() && !lscpNode.hasParameters()) {
                    throw new IllegalStateException("Invalid command!");
                }
                return new String[0];
            }
            if (!LscpUtils.checkPartialCommand(string3, lscpNode)) {
                throw new IllegalStateException("Invalid command!");
            }
            LscpNode lscpNode2 = LscpUtils.checkCommand(string3, lscpNode);
            if (lscpNode2 != null) {
                lscpNode = lscpNode2;
                if (string2.length() > 0) {
                    string2 = string2 + " ";
                }
                string2 = string2 + string3;
                continue;
            }
            String[] stringArray2 = LscpUtils.getKeywords(lscpNode, string2, string3);
            return stringArray2;
        }
        return LscpUtils.getKeywords(lscpNode, string2, "");
    }

    private static String[] getKeywords(LscpNode lscpNode, String string, String string2) {
        Vector<String> vector = new Vector<String>();
        for (LscpNode lscpNode2 : lscpNode.getChildren()) {
            String string3;
            if (!lscpNode2.getName().startsWith(string2)) continue;
            String string4 = string3 = lscpNode2.isEndOfACommand() && !lscpNode2.hasParameters() ? "" : " ";
            if (string.length() != 0) {
                vector.add(string + " " + lscpNode2.getName() + string3);
                continue;
            }
            vector.add(lscpNode2.getName() + string3);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public static String[] getCommandList() {
        Vector<String> vector = new Vector<String>();
        LscpUtils.addVariants(LscpTree.getRoot(), vector);
        return vector.toArray(new String[vector.size()]);
    }

    private static void addVariants(LscpNode lscpNode, Vector<String> vector) {
        LscpUtils.addVariants(lscpNode, vector, new String(""));
    }

    private static void addVariants(LscpNode lscpNode, Vector<String> vector, String string) {
        if (lscpNode.getChildren().length == 0) {
            vector.add(string + lscpNode.getName());
            return;
        }
        if (lscpNode.isEndOfACommand()) {
            vector.add(string + lscpNode.getName());
        }
        if (lscpNode.getName().length() > 0) {
            string = string + lscpNode.getName() + " ";
        }
        for (LscpNode lscpNode2 : lscpNode.getChildren()) {
            LscpUtils.addVariants(lscpNode2, vector, string);
        }
    }
}

