/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public enum MetadataVersion {
    IBP_3_3_IV3(7, "3.3", "IV3", true),
    IBP_3_4_IV0(8, "3.4", "IV0", true),
    IBP_3_5_IV0(9, "3.5", "IV0", false),
    IBP_3_5_IV1(10, "3.5", "IV1", false),
    IBP_3_5_IV2(11, "3.5", "IV2", true),
    IBP_3_6_IV0(12, "3.6", "IV0", false),
    IBP_3_6_IV1(13, "3.6", "IV1", true),
    IBP_3_6_IV2(14, "3.6", "IV2", true),
    IBP_3_7_IV0(15, "3.7", "IV0", true),
    IBP_3_7_IV1(16, "3.7", "IV1", false),
    IBP_3_7_IV2(17, "3.7", "IV2", true),
    IBP_3_7_IV3(18, "3.7", "IV3", false),
    IBP_3_7_IV4(19, "3.7", "IV4", false),
    IBP_3_8_IV0(20, "3.8", "IV0", false),
    IBP_3_9_IV0(21, "3.9", "IV0", false),
    IBP_4_0_IV0(22, "4.0", "IV0", false),
    IBP_4_0_IV1(23, "4.0", "IV1", true),
    IBP_4_0_IV2(24, "4.0", "IV2", false),
    IBP_4_0_IV3(25, "4.0", "IV3", false),
    IBP_4_1_IV0(26, "4.1", "IV0", false),
    IBP_4_1_IV1(27, "4.1", "IV1", false),
    IBP_4_2_IV0(28, "4.2", "IV0", false),
    IBP_4_2_IV1(29, "4.2", "IV1", false);

    public static final String FEATURE_NAME = "metadata.version";
    public static final MetadataVersion MINIMUM_VERSION;
    public static final MetadataVersion LATEST_PRODUCTION;
    public static final MetadataVersion[] VERSIONS;
    private final short featureLevel;
    private final String release;
    private final String ibpVersion;
    private final boolean didMetadataChange;
    private static final Map<String, MetadataVersion> IBP_VERSIONS;

    private MetadataVersion(int featureLevel, String release, String subVersion, boolean didMetadataChange) {
        this.featureLevel = (short)featureLevel;
        this.release = release;
        this.ibpVersion = subVersion.isEmpty() ? release : String.format("%s-%s", release, subVersion);
        this.didMetadataChange = didMetadataChange;
    }

    public String featureName() {
        return FEATURE_NAME;
    }

    public short featureLevel() {
        return this.featureLevel;
    }

    public boolean isScramSupported() {
        return this.isAtLeast(IBP_3_5_IV2);
    }

    public boolean isLeaderEpochBumpRequiredOnIsrShrink() {
        return !this.isAtLeast(IBP_3_6_IV0);
    }

    public boolean isMetadataTransactionSupported() {
        return this.isAtLeast(IBP_3_6_IV1);
    }

    public boolean isDelegationTokenSupported() {
        return this.isAtLeast(IBP_3_6_IV2);
    }

    public boolean isDirectoryAssignmentSupported() {
        return this.isAtLeast(IBP_3_7_IV2);
    }

    public boolean isElrSupported() {
        return this.isAtLeast(IBP_4_0_IV1);
    }

    public boolean isMigrationSupported() {
        return this.isAtLeast(IBP_3_4_IV0);
    }

    public short registerBrokerRecordVersion() {
        if (this.isDirectoryAssignmentSupported()) {
            return 3;
        }
        if (this.isMigrationSupported()) {
            return 2;
        }
        return 1;
    }

    public short registerControllerRecordVersion() {
        if (this.isAtLeast(IBP_3_7_IV0)) {
            return 0;
        }
        throw new RuntimeException("Controller registration is not supported in MetadataVersion " + String.valueOf((Object)this));
    }

    public boolean isControllerRegistrationSupported() {
        return this.isAtLeast(IBP_3_7_IV0);
    }

    public short partitionChangeRecordVersion() {
        if (this.isElrSupported()) {
            return 2;
        }
        if (this.isDirectoryAssignmentSupported()) {
            return 1;
        }
        return 0;
    }

    public short partitionRecordVersion() {
        if (this.isElrSupported()) {
            return 2;
        }
        if (this.isDirectoryAssignmentSupported()) {
            return 1;
        }
        return 0;
    }

    public short fetchRequestVersion() {
        if (this.isAtLeast(IBP_4_1_IV1)) {
            return 18;
        }
        if (this.isAtLeast(IBP_3_9_IV0)) {
            return 17;
        }
        if (this.isAtLeast(IBP_3_7_IV4)) {
            return 16;
        }
        if (this.isAtLeast(IBP_3_5_IV1)) {
            return 15;
        }
        if (this.isAtLeast(IBP_3_5_IV0)) {
            return 14;
        }
        return 13;
    }

    public short listOffsetRequestVersion() {
        if (this.isAtLeast(IBP_4_0_IV3)) {
            return 10;
        }
        if (this.isAtLeast(IBP_3_9_IV0)) {
            return 9;
        }
        if (this.isAtLeast(IBP_3_5_IV0)) {
            return 8;
        }
        return 7;
    }

    public boolean isProduction() {
        return this.compareTo(LATEST_PRODUCTION) <= 0;
    }

    public String shortVersion() {
        return this.release;
    }

    public String version() {
        return this.ibpVersion;
    }

    public boolean didMetadataChange() {
        return this.didMetadataChange;
    }

    Optional<MetadataVersion> previous() {
        int idx = this.ordinal();
        if (idx > 0) {
            return Optional.of(VERSIONS[idx - 1]);
        }
        return Optional.empty();
    }

    public static MetadataVersion fromVersionString(String versionString) {
        int numSegments = 2;
        String[] versionSegments = versionString.split(Pattern.quote("."));
        String key = numSegments >= versionSegments.length ? versionString : String.join((CharSequence)".", Arrays.copyOfRange(versionSegments, 0, numSegments));
        return Optional.ofNullable(IBP_VERSIONS.get(key)).orElseThrow(() -> new IllegalArgumentException("Version " + versionString + " is not a valid version. The minimum version is " + String.valueOf((Object)MINIMUM_VERSION) + " and the maximum version is " + String.valueOf((Object)MetadataVersion.latestTesting())));
    }

    public static MetadataVersion fromFeatureLevel(short version) {
        for (MetadataVersion metadataVersion : MetadataVersion.values()) {
            if (metadataVersion.featureLevel() != version) continue;
            return metadataVersion;
        }
        throw new IllegalArgumentException("No MetadataVersion with feature level " + version + ". Valid feature levels are from " + MetadataVersion.MINIMUM_VERSION.featureLevel + " to " + MetadataVersion.latestTesting().featureLevel + ".");
    }

    public static MetadataVersion latestTesting() {
        return VERSIONS[VERSIONS.length - 1];
    }

    public static MetadataVersion latestProduction() {
        return LATEST_PRODUCTION;
    }

    public static boolean checkIfMetadataChanged(MetadataVersion sourceVersion, MetadataVersion targetVersion) {
        MetadataVersion lowVersion;
        MetadataVersion highVersion;
        if (sourceVersion == targetVersion) {
            return false;
        }
        if (sourceVersion.compareTo(targetVersion) < 0) {
            highVersion = targetVersion;
            lowVersion = sourceVersion;
        } else {
            highVersion = sourceVersion;
            lowVersion = targetVersion;
        }
        return MetadataVersion.checkIfMetadataChangedOrdered(highVersion, lowVersion);
    }

    private static boolean checkIfMetadataChangedOrdered(MetadataVersion highVersion, MetadataVersion lowVersion) {
        Optional<MetadataVersion> prev;
        MetadataVersion version = highVersion;
        while (!version.didMetadataChange() && version != lowVersion && (prev = version.previous()).isPresent()) {
            version = prev.get();
        }
        return version != lowVersion;
    }

    public boolean isAtLeast(MetadataVersion otherVersion) {
        return this.compareTo(otherVersion) >= 0;
    }

    public boolean isLessThan(MetadataVersion otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    public String toString() {
        return this.ibpVersion;
    }

    static {
        MINIMUM_VERSION = IBP_3_3_IV3;
        LATEST_PRODUCTION = IBP_4_1_IV1;
        MetadataVersion[] enumValues = MetadataVersion.values();
        VERSIONS = Arrays.copyOf(enumValues, enumValues.length);
        IBP_VERSIONS = new HashMap<String, MetadataVersion>();
        HashMap<String, MetadataVersion> maxInterVersion = new HashMap<String, MetadataVersion>();
        for (MetadataVersion metadataVersion : VERSIONS) {
            if (metadataVersion.isProduction()) {
                maxInterVersion.put(metadataVersion.release, metadataVersion);
            }
            IBP_VERSIONS.put(metadataVersion.ibpVersion, metadataVersion);
        }
        IBP_VERSIONS.putAll(maxInterVersion);
    }
}

