/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.light;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.utils.KeycloakModelUtils;

class LightweightConsentEntity {
    private String clientId;
    private Long createdDate;
    private Set<String> grantedClientScopesIds;
    private Long lastUpdatedDate;

    LightweightConsentEntity() {
    }

    public static LightweightConsentEntity fromModel(UserConsentModel model) {
        long currentTime = Time.currentTimeMillis();
        LightweightConsentEntity consentEntity = new LightweightConsentEntity();
        consentEntity.setClientId(model.getClient().getId());
        consentEntity.setCreatedDate(currentTime);
        consentEntity.setLastUpdatedDate(currentTime);
        model.getGrantedClientScopes().stream().map(ClientScopeModel::getId).forEach(consentEntity::addGrantedClientScopesId);
        return consentEntity;
    }

    public static UserConsentModel toModel(RealmModel realm, LightweightConsentEntity entity) {
        if (entity == null) {
            return null;
        }
        ClientModel client = realm.getClientById(entity.getClientId());
        if (client == null) {
            throw new ModelException("Client with id " + entity.getClientId() + " is not available");
        }
        UserConsentModel model = new UserConsentModel(client);
        model.setCreatedDate(entity.getCreatedDate());
        model.setLastUpdatedDate(entity.getLastUpdatedDate());
        Set<String> grantedClientScopesIds = entity.getGrantedClientScopesIds();
        if (grantedClientScopesIds != null && !grantedClientScopesIds.isEmpty()) {
            grantedClientScopesIds.stream().map(scopeId -> KeycloakModelUtils.findClientScopeById(realm, client, scopeId)).filter(Objects::nonNull).forEach(arg_0 -> ((UserConsentModel)model).addGrantedClientScope(arg_0));
        }
        return model;
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.grantedClientScopesIds, this.lastUpdatedDate);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LightweightConsentEntity other = (LightweightConsentEntity)obj;
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.lastUpdatedDate, other.lastUpdatedDate) && Objects.equals(this.grantedClientScopesIds, other.grantedClientScopesIds);
    }

    public String toString() {
        return String.format("%s@%08x", "LightweightConsentEntity", System.identityHashCode(this));
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public Set<String> getGrantedClientScopesIds() {
        return this.grantedClientScopesIds;
    }

    public void removeGrantedClientScopesId(String clientScopeId) {
        if (this.grantedClientScopesIds == null) {
            return;
        }
        if (this.grantedClientScopesIds.remove(clientScopeId)) {
            this.lastUpdatedDate = Time.currentTimeMillis();
        }
    }

    public void setGrantedClientScopesIds(Set<String> clientScopeIds) {
        HashSet<String> hashSet = clientScopeIds = clientScopeIds == null ? null : new HashSet<String>(clientScopeIds);
        if (clientScopeIds != null) {
            clientScopeIds.removeIf(Objects::isNull);
            if (clientScopeIds.isEmpty()) {
                clientScopeIds = null;
            }
        }
        this.grantedClientScopesIds = clientScopeIds;
        this.lastUpdatedDate = Time.currentTimeMillis();
    }

    public void addGrantedClientScopesId(String clientScopeId) {
        if (clientScopeId == null) {
            return;
        }
        if (this.grantedClientScopesIds == null) {
            this.grantedClientScopesIds = new HashSet<String>();
        }
        this.grantedClientScopesIds.add(clientScopeId);
        this.lastUpdatedDate = Time.currentTimeMillis();
    }

    public Long getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(Long lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }
}

