/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.nio.ByteBuffer;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.BlobCopyingBinder;
import oracle.jdbc.driver.DatumBinder;
import oracle.jdbc.driver.OraclePreparedStatement;

class BlobBinder
extends DatumBinder {
    Binder theBlobCopyingBinder = null;

    static void init(Binder x) {
        x.type = (short)113;
        x.bytelen = 4000;
    }

    BlobBinder(byte[] val) {
        this(val, null);
    }

    BlobBinder(byte[] val, ByteBuffer blobData) {
        super(val, blobData);
        BlobBinder.init(this);
        this.skipBindChecksumForLobs = true;
    }

    @Override
    Binder copyingBinder() {
        if (this.theBlobCopyingBinder == null) {
            this.theBlobCopyingBinder = new BlobCopyingBinder();
        }
        return this.theBlobCopyingBinder;
    }

    @Override
    void lastBoundValueCleanup(OraclePreparedStatement stmt, int bindPosition) {
        if (stmt.lastBoundBlobs != null) {
            stmt.moveTempLobsToFree(stmt.lastBoundBlobs[bindPosition]);
        }
    }
}

