/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.oracle;

import java.sql.Connection;
import javax.sql.XAConnection;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.jdbc.proxy.ConnectionProxyFactory;
import oracle.ucp.jdbc.proxy.Creator;
import oracle.ucp.jdbc.proxy.oracle.ConnectionProxy;
import oracle.ucp.jdbc.proxy.oracle.ReplayableConnectionProxy;
import oracle.ucp.jdbc.proxy.oracle.ResultSetProxy;
import oracle.ucp.jdbc.proxy.oracle.StatementProxy;
import oracle.ucp.proxy.ProxyFactory;

public final class OracleConnectionProxyFactory
implements ConnectionProxyFactory {
    private final ProxyFactory nonReplayableFactory = ProxyFactory.createProxyFactory("oracle.ucp.jdbc.proxy", ConnectionProxy.class, StatementProxy.class, ResultSetProxy.class);
    private final ProxyFactory replayableFactory = ProxyFactory.createProxyFactory("oracle.ucp.jdbc.proxy", ReplayableConnectionProxy.class, StatementProxy.class, ResultSetProxy.class);

    private <T> T proxyForCreate(final UniversalConnectionPool ucp, final UniversalPooledConnection upc) {
        Creator creator = new Creator(){

            @Override
            public UniversalConnectionPool getUCP() {
                return ucp;
            }

            @Override
            public UniversalPooledConnection getUPC() {
                return upc;
            }
        };
        Object t = upc.getPhysicalConnection();
        return (T)(upc.getPhysicalConnection() instanceof ReplayableConnection ? this.replayableFactory.proxyForCreate(t, creator, null, null) : this.nonReplayableFactory.proxyForCreate(t, creator, null, null));
    }

    @Override
    public Connection proxyForConnection(UniversalConnectionPool ucp, UniversalPooledConnection upc) {
        return (Connection)this.proxyForCreate(ucp, upc);
    }

    @Override
    public XAConnection proxyForXAConnection(UniversalConnectionPool ucp, UniversalPooledConnection upc) {
        return (XAConnection)this.proxyForCreate(ucp, upc);
    }

    public Connection proxyForConnection(Connection delegate, Object creator) {
        return delegate instanceof ReplayableConnection ? this.replayableFactory.proxyForCreate(delegate, creator) : this.nonReplayableFactory.proxyForCreate(delegate, creator);
    }
}

