/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query.functionscore;

import java.util.Map;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.index.query.functionscore.ExponentialDecayFunctionBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import org.opensearch.protobufs.DateDecayPlacement;
import org.opensearch.protobufs.DecayFunction;
import org.opensearch.protobufs.DecayPlacement;
import org.opensearch.protobufs.GeoDecayPlacement;
import org.opensearch.protobufs.MultiValueMode;
import org.opensearch.protobufs.NumericDecayPlacement;
import org.opensearch.transport.grpc.proto.request.common.GeoPointProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.query.functionscore.DecayFunctionProtoUtils;

class ExpDecayFunctionProtoUtils {
    private ExpDecayFunctionProtoUtils() {
    }

    static ScoreFunctionBuilder<?> fromProto(DecayFunction decayFunction) {
        ExponentialDecayFunctionBuilder builder;
        if (decayFunction == null || decayFunction.getPlacementCount() == 0) {
            throw new IllegalArgumentException("DecayFunction must have at least one placement");
        }
        Map.Entry entry = decayFunction.getPlacementMap().entrySet().iterator().next();
        String fieldName = (String)entry.getKey();
        DecayPlacement decayPlacement = (DecayPlacement)entry.getValue();
        if (decayPlacement.hasNumericDecayPlacement()) {
            builder = ExpDecayFunctionProtoUtils.parseNumericExpDecay(fieldName, decayPlacement.getNumericDecayPlacement());
        } else if (decayPlacement.hasGeoDecayPlacement()) {
            builder = ExpDecayFunctionProtoUtils.parseGeoExpDecay(fieldName, decayPlacement.getGeoDecayPlacement());
        } else if (decayPlacement.hasDateDecayPlacement()) {
            builder = ExpDecayFunctionProtoUtils.parseDateExpDecay(fieldName, decayPlacement.getDateDecayPlacement());
        } else {
            throw new IllegalArgumentException("Unsupported decay placement type");
        }
        if (decayFunction.hasMultiValueMode() && decayFunction.getMultiValueMode() != MultiValueMode.MULTI_VALUE_MODE_UNSPECIFIED) {
            builder.setMultiValueMode(DecayFunctionProtoUtils.parseMultiValueMode(decayFunction.getMultiValueMode()));
        }
        return builder;
    }

    private static ExponentialDecayFunctionBuilder parseNumericExpDecay(String fieldName, NumericDecayPlacement numericPlacement) {
        ExponentialDecayFunctionBuilder builder = numericPlacement.hasDecay() ? new ExponentialDecayFunctionBuilder(fieldName, (Object)numericPlacement.getOrigin(), (Object)numericPlacement.getScale(), (Object)(numericPlacement.hasOffset() ? Double.valueOf(numericPlacement.getOffset()) : null), numericPlacement.getDecay()) : new ExponentialDecayFunctionBuilder(fieldName, (Object)numericPlacement.getOrigin(), (Object)numericPlacement.getScale(), numericPlacement.hasOffset() ? Double.valueOf(numericPlacement.getOffset()) : null);
        return builder;
    }

    private static ExponentialDecayFunctionBuilder parseGeoExpDecay(String fieldName, GeoDecayPlacement geoPlacement) {
        GeoPoint geoPoint = GeoPointProtoUtils.parseGeoPoint(geoPlacement.getOrigin());
        ExponentialDecayFunctionBuilder builder = geoPlacement.hasDecay() ? new ExponentialDecayFunctionBuilder(fieldName, (Object)geoPoint, (Object)geoPlacement.getScale(), (Object)(geoPlacement.hasOffset() ? geoPlacement.getOffset() : null), geoPlacement.getDecay()) : new ExponentialDecayFunctionBuilder(fieldName, (Object)geoPoint, (Object)geoPlacement.getScale(), (Object)(geoPlacement.hasOffset() ? geoPlacement.getOffset() : null));
        return builder;
    }

    private static ExponentialDecayFunctionBuilder parseDateExpDecay(String fieldName, DateDecayPlacement datePlacement) {
        String origin;
        String string = origin = datePlacement.hasOrigin() ? datePlacement.getOrigin() : null;
        ExponentialDecayFunctionBuilder builder = datePlacement.hasDecay() ? new ExponentialDecayFunctionBuilder(fieldName, (Object)origin, (Object)datePlacement.getScale(), (Object)(datePlacement.hasOffset() ? datePlacement.getOffset() : null), datePlacement.getDecay()) : new ExponentialDecayFunctionBuilder(fieldName, (Object)origin, (Object)datePlacement.getScale(), (Object)(datePlacement.hasOffset() ? datePlacement.getOffset() : null));
        return builder;
    }
}

