/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.DIRECT_KEY_WRAPPING;
import software.amazon.cryptography.materialproviders.model.IntermediateKeyWrapping;

public class EdkWrappingAlgorithm {
    private final DIRECT_KEY_WRAPPING DIRECT_KEY_WRAPPING;
    private final IntermediateKeyWrapping IntermediateKeyWrapping;

    protected EdkWrappingAlgorithm(BuilderImpl builder) {
        this.DIRECT_KEY_WRAPPING = builder.DIRECT_KEY_WRAPPING();
        this.IntermediateKeyWrapping = builder.IntermediateKeyWrapping();
    }

    public DIRECT_KEY_WRAPPING DIRECT_KEY_WRAPPING() {
        return this.DIRECT_KEY_WRAPPING;
    }

    public IntermediateKeyWrapping IntermediateKeyWrapping() {
        return this.IntermediateKeyWrapping;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected DIRECT_KEY_WRAPPING DIRECT_KEY_WRAPPING;
        protected IntermediateKeyWrapping IntermediateKeyWrapping;

        protected BuilderImpl() {
        }

        protected BuilderImpl(EdkWrappingAlgorithm model) {
            this.DIRECT_KEY_WRAPPING = model.DIRECT_KEY_WRAPPING();
            this.IntermediateKeyWrapping = model.IntermediateKeyWrapping();
        }

        @Override
        public Builder DIRECT_KEY_WRAPPING(DIRECT_KEY_WRAPPING DIRECT_KEY_WRAPPING2) {
            this.DIRECT_KEY_WRAPPING = DIRECT_KEY_WRAPPING2;
            return this;
        }

        @Override
        public DIRECT_KEY_WRAPPING DIRECT_KEY_WRAPPING() {
            return this.DIRECT_KEY_WRAPPING;
        }

        @Override
        public Builder IntermediateKeyWrapping(IntermediateKeyWrapping IntermediateKeyWrapping2) {
            this.IntermediateKeyWrapping = IntermediateKeyWrapping2;
            return this;
        }

        @Override
        public IntermediateKeyWrapping IntermediateKeyWrapping() {
            return this.IntermediateKeyWrapping;
        }

        @Override
        public EdkWrappingAlgorithm build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`EdkWrappingAlgorithm` is a Union. A Union MUST have one and only one value set.");
            }
            return new EdkWrappingAlgorithm(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.DIRECT_KEY_WRAPPING, this.IntermediateKeyWrapping};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder DIRECT_KEY_WRAPPING(DIRECT_KEY_WRAPPING var1);

        public DIRECT_KEY_WRAPPING DIRECT_KEY_WRAPPING();

        public Builder IntermediateKeyWrapping(IntermediateKeyWrapping var1);

        public IntermediateKeyWrapping IntermediateKeyWrapping();

        public EdkWrappingAlgorithm build();
    }
}

