/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.Bytes;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.TimeUnit;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.RecoveryResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class RecoveryRequest
extends CatRequestBase
implements ToCopyableBuilder<Builder, RecoveryRequest> {
    @Nullable
    private final Boolean activeOnly;
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final Boolean detailed;
    @Nonnull
    private final List<String> index;
    @Nullable
    private final TimeUnit time;
    public static final Endpoint<RecoveryRequest, RecoveryResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RecoveryRequest, RecoveryResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_cat/recovery";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat/recovery/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.index), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, RecoveryResponse._DESERIALIZER);

    private RecoveryRequest(Builder builder) {
        super(builder);
        this.activeOnly = builder.activeOnly;
        this.bytes = builder.bytes;
        this.detailed = builder.detailed;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.time = builder.time;
    }

    public static RecoveryRequest of(Function<Builder, ObjectBuilder<RecoveryRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean activeOnly() {
        return this.activeOnly;
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public final Boolean detailed() {
        return this.detailed;
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.activeOnly != null) {
            params.put("active_only", String.valueOf(this.activeOnly));
        }
        if (this.bytes != null) {
            params.put("bytes", this.bytes.jsonValue());
        }
        if (this.detailed != null) {
            params.put("detailed", String.valueOf(this.detailed));
        }
        if (this.time != null) {
            params.put("time", this.time.jsonValue());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.activeOnly);
        result = 31 * result + Objects.hashCode(this.bytes);
        result = 31 * result + Objects.hashCode(this.detailed);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.time);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecoveryRequest other = (RecoveryRequest)o;
        return Objects.equals(this.activeOnly, other.activeOnly) && Objects.equals(this.bytes, other.bytes) && Objects.equals(this.detailed, other.detailed) && Objects.equals(this.index, other.index) && Objects.equals(this.time, other.time);
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, RecoveryRequest> {
        @Nullable
        private Boolean activeOnly;
        @Nullable
        private Bytes bytes;
        @Nullable
        private Boolean detailed;
        @Nullable
        private List<String> index;
        @Nullable
        private TimeUnit time;

        public Builder() {
        }

        private Builder(RecoveryRequest o) {
            super(o);
            this.activeOnly = o.activeOnly;
            this.bytes = o.bytes;
            this.detailed = o.detailed;
            this.index = Builder._listCopy(o.index);
            this.time = o.time;
        }

        private Builder(Builder o) {
            super(o);
            this.activeOnly = o.activeOnly;
            this.bytes = o.bytes;
            this.detailed = o.detailed;
            this.index = Builder._listCopy(o.index);
            this.time = o.time;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder activeOnly(@Nullable Boolean value) {
            this.activeOnly = value;
            return this;
        }

        @Nonnull
        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        @Nonnull
        public final Builder detailed(@Nullable Boolean value) {
            this.detailed = value;
            return this;
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Nonnull
        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Override
        @Nonnull
        public RecoveryRequest build() {
            this._checkSingleUse();
            return new RecoveryRequest(this);
        }
    }
}

