# This file has been autogenerated by the pywayland scanner

# Copyright 2022 Simon Ser
# Copyright 2022 Red Hat, Inc.
# Copyright 2022 Collabora, Ltd.
# Copyright 2022-2025 Red Hat, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSurface
from .wp_color_representation_surface_v1 import WpColorRepresentationSurfaceV1


class WpColorRepresentationManagerV1(Interface):
    """Color representation manager singleton

    A singleton global interface used for getting color representation
    extensions for :class:`~pywayland.protocol.wayland.WlSurface`. The
    extension interfaces allow setting the color representation of surfaces.

    Compositors should never remove this global.
    """

    name = "wp_color_representation_manager_v1"
    version = 1

    class error(enum.IntEnum):
        surface_exists = 1


class WpColorRepresentationManagerV1Proxy(Proxy[WpColorRepresentationManagerV1]):
    interface = WpColorRepresentationManagerV1

    @WpColorRepresentationManagerV1.request()
    def destroy(self) -> None:
        """Destroy the manager

        Destroy the :class:`WpColorRepresentationManagerV1` object. This does
        not affect any other objects in any way.
        """
        self._marshal(0)
        self._destroy()

    @WpColorRepresentationManagerV1.request(
        Argument(ArgumentType.NewId, interface=WpColorRepresentationSurfaceV1),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def get_surface(self, surface: WlSurface) -> Proxy[WpColorRepresentationSurfaceV1]:
        """Create a color representation interface for a :class:`~pywayland.protocol.wayland.WlSurface`

        If a
        :class:`~pywayland.protocol.color_representation_v1.WpColorRepresentationSurfaceV1`
        object already exists for the given
        :class:`~pywayland.protocol.wayland.WlSurface`, the protocol error
        surface_exists is raised.

        This creates a new color
        :class:`~pywayland.protocol.color_representation_v1.WpColorRepresentationSurfaceV1`
        object for the given :class:`~pywayland.protocol.wayland.WlSurface`.

        See the
        :class:`~pywayland.protocol.color_representation_v1.WpColorRepresentationSurfaceV1`
        interface for more details.

        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.color_representation_v1.WpColorRepresentationSurfaceV1`
        """
        id = self._marshal_constructor(1, WpColorRepresentationSurfaceV1, surface)
        return id


class WpColorRepresentationManagerV1Resource(Resource):
    interface = WpColorRepresentationManagerV1

    @WpColorRepresentationManagerV1.event(
        Argument(ArgumentType.Uint),
    )
    def supported_alpha_mode(self, alpha_mode: int) -> None:
        """Supported alpha modes

        When this object is created, it shall immediately send this event once
        for each alpha mode the compositor supports.

        For the definition of the supported values, see the
        :class:`~pywayland.protocol.color_representation_v1.WpColorRepresentationSurfaceV1`::alpha_mode
        enum.

        :param alpha_mode:
            supported alpha mode
        :type alpha_mode:
            `ArgumentType.Uint`
        """
        self._post_event(0, alpha_mode)

    @WpColorRepresentationManagerV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def supported_coefficients_and_ranges(self, coefficients: int, range: int) -> None:
        """Supported matrix coefficients and ranges

        When this object is created, it shall immediately send this event once
        for each matrix coefficient and color range combination the compositor
        supports.

        For the definition of the supported values, see the
        :class:`~pywayland.protocol.color_representation_v1.WpColorRepresentationSurfaceV1`::coefficients
        and
        :class:`~pywayland.protocol.color_representation_v1.WpColorRepresentationSurfaceV1`::range
        enums.

        :param coefficients:
            supported matrix coefficients
        :type coefficients:
            `ArgumentType.Uint`
        :param range:
            full range flag
        :type range:
            `ArgumentType.Uint`
        """
        self._post_event(1, coefficients, range)

    @WpColorRepresentationManagerV1.event()
    def done(self) -> None:
        """All features have been sent

        This event is sent when all supported features have been sent.
        """
        self._post_event(2)


class WpColorRepresentationManagerV1Global(Global):
    interface = WpColorRepresentationManagerV1


WpColorRepresentationManagerV1._gen_c()
WpColorRepresentationManagerV1.proxy_class = WpColorRepresentationManagerV1Proxy
WpColorRepresentationManagerV1.resource_class = WpColorRepresentationManagerV1Resource
WpColorRepresentationManagerV1.global_class = WpColorRepresentationManagerV1Global
