\name{WhiteTopHatImageFilter}
\alias{WhiteTopHatImageFilter}
\title{WhiteTopHatImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
White top hat extracts local maxima that are larger than the
structuring element.
WhiteTopHatImageFilter}
\details{
Top-hats are described in Chapter 4.5 of Pierre Soille's book
"Morphological Image Analysis: Principles and Applications", Second
Edition, Springer, 2003.
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
WhiteTopHat for the procedural interface
itk::WhiteTopHatImageFilter for the Doxygen on the original ITK class.
WhiteTopHatImageFilter}
%C++ includes: sitkWhiteTopHatImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::vector< unsigned int > GetKernelRadius() const:}{
Get the radius of the kernel structuring element.
}
\item{KernelEnum GetKernelType() const:}{
Get the kernel or structuring element used for the morphology.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetSafeBorder() const:}{
A safe border is added to input image to avoid borders effects and
remove it once the closing is done
}
\item{Self SafeBorderOff():}{}
\item{Self SafeBorderOn():}{
Set the value of SafeBorder to true or false respectfully.
}
\item{Self SetKernelRadius(std::vector< unsigned int > KernelRadius):}{
Set the radius of the kernel structuring element.
}
\item{Self SetKernelRadius(unsigned int value):}{
Set the values of the KernelRadius vector all to value
}
\item{Self SetKernelType(KernelEnum KernelType):}{
Set the kernel or structuring element used for the morphology.
}
\item{Self SetSafeBorder(bool SafeBorder):}{
A safe border is added to input image to avoid borders effects and
remove it once the closing is done
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ WhiteTopHatImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~WhiteTopHatImageFilter():}{
Destructor
}
}
}
