
# 13 "toplevel/g_toplevel.mlg"
 
open Procq
open Procq.Prim
open Vernacexpr

(* Vernaculars specific to the toplevel *)
type vernac_toplevel =
  | VernacBackTo of int
  | VernacDrop
  | VernacQuit
  | VernacControl of vernac_control
  | VernacShowGoal of { gid : int; sid: int }
  | VernacShowProofDiffs of Proof_diffs.diffOpt

let vernac_toplevel = Entry.make "toplevel:vernac_toplevel"

let err () = raise Gramlib.Stream.Failure

let test_show_goal =
  let open Procq.Lookahead in
  to_entry "test_show_goal" begin
   lk_kw "Show" >> lk_kw "Goal" >> lk_nat
  end


# 29 "toplevel/g_toplevel.ml"

let _ = let () =
  Procq.grammar_extend vernac_toplevel
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm Pvernac.Vernac_.main_entry)))
                            (fun cmd loc -> 
# 53 "toplevel/g_toplevel.mlg"
                match cmd with
              | None -> None
              | Some v -> Some (VernacControl v) 
# 43 "toplevel/g_toplevel.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("Show"))))))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Proof"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Diffs"))))))
                             ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PIDENT (Some
                                                                    ("removed"))))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 49 "toplevel/g_toplevel.mlg"
                                                                                         () 
# 68 "toplevel/g_toplevel.ml"
)]))))
                            ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                           (fun _ removed _ _ _ loc -> 
# 50 "toplevel/g_toplevel.mlg"
          Some (VernacShowProofDiffs
          (if removed = None then Proof_diffs.DiffOn else Proof_diffs.DiffRemoved)) 
# 75 "toplevel/g_toplevel.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.nterm test_show_goal)))
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("Show"))))))
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("Goal"))))))
                               ((Procq.Symbol.nterm natural)))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("at"))))))
                             ((Procq.Symbol.nterm natural)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                           (fun _ sid _ gid _ _ _ loc -> 
# 48 "toplevel/g_toplevel.mlg"
            Some (VernacShowGoal {gid; sid}) 
# 98 "toplevel/g_toplevel.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("BackTo"))))))
                             ((Procq.Symbol.nterm natural)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                           (fun _ n _ loc -> 
# 45 "toplevel/g_toplevel.mlg"
          Some (VernacBackTo n) 
# 111 "toplevel/g_toplevel.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Quit"))))))
                            ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                           (fun _ _ loc -> 
# 43 "toplevel/g_toplevel.mlg"
                               Some VernacQuit 
# 122 "toplevel/g_toplevel.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Drop"))))))
                            ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                           (fun _ _ loc -> 
# 42 "toplevel/g_toplevel.mlg"
                               Some VernacDrop 
# 133 "toplevel/g_toplevel.ml"
)])]))
  in ()


# 61 "toplevel/g_toplevel.mlg"
 

let vernac_toplevel pm =
  Pvernac.Unsafe.set_tactic_entry pm;
  vernac_toplevel


# 146 "toplevel/g_toplevel.ml"

