/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


#ifndef QOAI_HTTPREQUESTWORKER_H
#define QOAI_HTTPREQUESTWORKER_H

#include "openapicommoncommonexports.h"

#include <QtCore/qcontainerfwd.h>
#include <QtCore/qstring.h> // for argument default value initialization

#include <memory>

QT_BEGIN_NAMESPACE
class QHttpHeaders;
class QHttpMultiPart;
class QNetworkRequest;
class QNetworkRequestFactory;
class QRestAccessManager;
class QRestReply;
class QUrlQuery;
QT_END_NAMESPACE

QT_BEGIN_NAMESPACE

namespace QtOpenApiCommon {

class QOAIHttpFileElement;

class QOAIHttpRequestInputPrivate;

class QOAIHttpRequestInput
{
public:
    enum class VariableLayout {
        NotSet,
        Address,
        UrlEncoded,
        Multipart,
    };

    OPENAPICOMMON_COMMON_EXPORT QOAIHttpRequestInput();
    OPENAPICOMMON_COMMON_EXPORT ~QOAIHttpRequestInput();
    OPENAPICOMMON_COMMON_EXPORT
    QOAIHttpRequestInput(const QString &vUrlStr, const QString &vHttpMethod);
    Q_DISABLE_COPY_MOVE(QOAIHttpRequestInput)

    OPENAPICOMMON_COMMON_EXPORT
    void addVariable(const QString &key, const QString &value);
    OPENAPICOMMON_COMMON_EXPORT
    void addFieldHeaders(const QString &key, const QString &value);
    OPENAPICOMMON_COMMON_EXPORT
    void addFile(const QString &variableName, const QString &localFilename, const QString &mimeType);

    OPENAPICOMMON_COMMON_EXPORT void setVariableLayout(VariableLayout layout);
    OPENAPICOMMON_COMMON_EXPORT VariableLayout variableLayout() const;

    OPENAPICOMMON_COMMON_EXPORT void setHeaders(const QHttpHeaders &newHeaders);
    OPENAPICOMMON_COMMON_EXPORT QHttpHeaders headers() const;
    OPENAPICOMMON_COMMON_EXPORT QHttpHeaders &headers();

    OPENAPICOMMON_COMMON_EXPORT void setIsFormData(bool isForm);
    OPENAPICOMMON_COMMON_EXPORT bool isFormData() const;

    OPENAPICOMMON_COMMON_EXPORT QString httpMethod() const;

    OPENAPICOMMON_COMMON_EXPORT bool hasMultiPart() const;
    OPENAPICOMMON_COMMON_EXPORT QHttpMultiPart* multiPart() const;
    OPENAPICOMMON_COMMON_EXPORT QHttpMultiPart* takeMultiPart();

    OPENAPICOMMON_COMMON_EXPORT void setRequestBody(const QByteArray &data);
    OPENAPICOMMON_COMMON_EXPORT QByteArray requestBody() const;

private:
    friend bool
    operator==(const QOAIHttpRequestInput &lhs, const QOAIHttpRequestInput &rhs) = delete;
    friend bool
    operator!=(const QOAIHttpRequestInput &lhs, const QOAIHttpRequestInput &rhs) = delete;

    friend size_t qHash(const QOAIHttpRequestInput &value) = delete;
    friend size_t qHash(const QOAIHttpRequestInput &value, size_t seed) = delete;

    friend class QOAIHttpRequestInputPrivate;
    std::unique_ptr<QOAIHttpRequestInputPrivate> d_ptr;
};

namespace QOAIHttpRequestWorker {
    OPENAPICOMMON_COMMON_EXPORT QOAIHttpFileElement getHttpFileElement(const QMap<QString, QOAIHttpFileElement> &files, const QString &fieldname = {});
    OPENAPICOMMON_COMMON_EXPORT QNetworkRequest getNetworkRequest(QOAIHttpRequestInput &input, QByteArray &requestContent, QNetworkRequestFactory factory, bool responseCompressionEnabled, bool requestCompressionEnabled);
    OPENAPICOMMON_COMMON_EXPORT QByteArray parseResponse(const QRestReply &reply, const QString &workDir, QMap<QString, QOAIHttpFileElement> *files = nullptr);

    enum class CompressionType {
        Deflate,
        Gzip,
        None,
    };
    OPENAPICOMMON_COMMON_EXPORT QByteArray decompressData(const QByteArray &data, CompressionType compressionType);
    OPENAPICOMMON_COMMON_EXPORT QByteArray compressData(const QByteArray &input, int level, CompressionType compressionType);
} // namespace QOAIHttpRequestWorker

} // namespace QtOpenApiCommon

QT_END_NAMESPACE

#endif // QOAI_HTTPREQUESTWORKER_H
