﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ivs/IVS_EXPORTS.h>
#include <aws/ivs/model/StreamKey.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IVS {
namespace Model {
class GetStreamKeyResult {
 public:
  AWS_IVS_API GetStreamKeyResult() = default;
  AWS_IVS_API GetStreamKeyResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IVS_API GetStreamKeyResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <zonbook></zonbook><xhtml></xhtml>
   */
  inline const StreamKey& GetStreamKey() const { return m_streamKey; }
  template <typename StreamKeyT = StreamKey>
  void SetStreamKey(StreamKeyT&& value) {
    m_streamKeyHasBeenSet = true;
    m_streamKey = std::forward<StreamKeyT>(value);
  }
  template <typename StreamKeyT = StreamKey>
  GetStreamKeyResult& WithStreamKey(StreamKeyT&& value) {
    SetStreamKey(std::forward<StreamKeyT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetStreamKeyResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  StreamKey m_streamKey;

  Aws::String m_requestId;
  bool m_streamKeyHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IVS
}  // namespace Aws
