/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntKeyMap<VALUE>
implements Map<Integer, VALUE> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient IntEntry<VALUE>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    private transient Set<IntEntry<VALUE>> entrySet = null;
    volatile transient Set<Integer> keySet = null;
    volatile transient Collection<VALUE> values = null;

    public IntKeyMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new IntEntry[capacity];
    }

    public IntKeyMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntKeyMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new IntEntry[16];
    }

    static int hash(long x) {
        int h = (int)(x ^ x >>> 32);
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(((Number)key).intValue());
    }

    public VALUE get(int key) {
        int hash = IntKeyMap.hash(key);
        int i = IntKeyMap.indexFor(hash, this.table.length);
        IntEntry<VALUE> e = this.table[i];
        while (e != null) {
            if (e.hash == hash && key == e.key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public boolean containsKey(int key) {
        int hash = IntKeyMap.hash(key);
        int i = IntKeyMap.indexFor(hash, this.table.length);
        IntEntry<VALUE> e = this.table[i];
        while (e != null) {
            if (e.hash == hash && key == e.key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    IntEntry<VALUE> getEntry(int key) {
        int hash = IntKeyMap.hash(key);
        int i = IntKeyMap.indexFor(hash, this.table.length);
        IntEntry<VALUE> e = this.table[i];
        while (e != null && (e.hash != hash || key != e.key)) {
            e = e.next;
        }
        return e;
    }

    @Override
    public VALUE put(int key, VALUE value) {
        int hash = IntKeyMap.hash(key);
        int i = IntKeyMap.indexFor(hash, this.table.length);
        IntEntry<VALUE> e = this.table[i];
        while (e != null) {
            if (e.hash == hash && key == e.key) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return null;
    }

    private void putForCreate(int key, VALUE value) {
        int hash = IntKeyMap.hash(key);
        int i = IntKeyMap.indexFor(hash, this.table.length);
        IntEntry<VALUE> e = this.table[i];
        while (e != null) {
            if (e.hash == hash && key == e.key) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, key, value, i);
    }

    void putAllForCreate(IntKeyMap<VALUE> m) {
        for (IntEntry e : m.entrySet()) {
            this.putForCreate(e.key, e.value);
        }
    }

    void resize(int newCapacity) {
        IntEntry<VALUE>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (this.size < this.threshold || oldCapacity > newCapacity) {
            return;
        }
        IntEntry[] newTable = new IntEntry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(IntEntry[] newTable) {
        IntEntry<VALUE>[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            IntEntry next;
            IntEntry<VALUE> e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = IntKeyMap.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    public void putAll(IntKeyMap<VALUE> t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        if (n >= this.threshold) {
            int capacity;
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            for (capacity = this.table.length; capacity < n; capacity <<= 1) {
            }
            this.resize(capacity);
        }
        for (IntEntry e : t.entrySet()) {
            this.put(e.key, (VALUE)e.value);
        }
    }

    public VALUE remove(int key) {
        IntEntry<VALUE> e = this.removeEntryForKey(key);
        return e == null ? null : (VALUE)e.value;
    }

    IntEntry<VALUE> removeEntryForKey(int key) {
        IntEntry<VALUE> prev;
        int hash = IntKeyMap.hash(key);
        int i = IntKeyMap.indexFor(hash, this.table.length);
        IntEntry<VALUE> e = prev = this.table[i];
        while (e != null) {
            IntEntry next = e.next;
            if (e.hash == hash && key == e.key) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    IntEntry<VALUE> removeMapping(Object o) {
        IntEntry<VALUE> prev;
        if (!(o instanceof IntEntry)) {
            return null;
        }
        IntEntry entry = (IntEntry)o;
        int hash = IntKeyMap.hash(entry.key);
        int i = IntKeyMap.indexFor(hash, this.table.length);
        IntEntry<VALUE> e = prev = this.table[i];
        while (e != null) {
            IntEntry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    @Override
    public void clear() {
        ++this.modCount;
        IntEntry<VALUE>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        IntEntry<VALUE>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            IntEntry<VALUE> e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public VALUE get(Object key) {
        return this.get(((Number)key).intValue());
    }

    @Override
    public VALUE put(Integer key, VALUE value) {
        return this.put((int)key, value);
    }

    @Override
    public VALUE remove(Object key) {
        return this.remove(((Number)key).intValue());
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends VALUE> t) {
        throw new UnsupportedOperationException();
    }

    private boolean containsNullValue() {
        IntEntry<VALUE>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            IntEntry<VALUE> e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    void addEntry(int hash, int key, VALUE value, int bucketIndex) {
        this.table[bucketIndex] = new IntEntry<VALUE>(hash, key, value, this.table[bucketIndex]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, int key, VALUE value, int bucketIndex) {
        this.table[bucketIndex] = new IntEntry<VALUE>(hash, key, value, this.table[bucketIndex]);
        ++this.size;
    }

    Iterator<Integer> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<VALUE> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<IntEntry<VALUE>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<Integer> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<VALUE> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    public static class IntEntry<VALUE>
    implements Map.Entry<Integer, VALUE> {
        final int key;
        VALUE value;
        final int hash;
        IntEntry<VALUE> next;

        IntEntry(int h, int k, VALUE v, IntEntry<VALUE> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        public int getInt() {
            return this.key;
        }

        @Override
        public Integer getKey() {
            return this.key;
        }

        @Override
        public VALUE getValue() {
            return this.value;
        }

        @Override
        public VALUE setValue(VALUE newValue) {
            VALUE oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            VALUE v2;
            VALUE v1;
            if (!(o instanceof IntEntry)) {
                return false;
            }
            IntEntry e = (IntEntry)o;
            return this.key == e.key && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            return IntKeyMap.hash(this.key) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + String.valueOf(this.getValue());
        }
    }

    private class KeyIterator
    extends HashIterator<Integer> {
        private KeyIterator() {
        }

        @Override
        public Integer next() {
            return this.nextEntry().key;
        }

        public int nextInt() {
            return this.nextEntry().key;
        }
    }

    private class ValueIterator
    extends HashIterator<VALUE> {
        private ValueIterator() {
        }

        @Override
        public VALUE next() {
            return this.nextEntry().value;
        }
    }

    private class EntryIterator
    extends HashIterator<IntEntry<VALUE>> {
        private EntryIterator() {
        }

        @Override
        public IntEntry<VALUE> next() {
            return this.nextEntry();
        }
    }

    private class KeySet
    extends AbstractSet<Integer> {
        private KeySet() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return IntKeyMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return IntKeyMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Number) {
                return IntKeyMap.this.containsKey(((Number)o).intValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Number) {
                return IntKeyMap.this.removeEntryForKey(((Number)o).intValue()) != null;
            }
            return false;
        }

        @Override
        public void clear() {
            IntKeyMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection<VALUE> {
        private Values() {
        }

        @Override
        public Iterator<VALUE> iterator() {
            return IntKeyMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return IntKeyMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return IntKeyMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            IntKeyMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet<IntEntry<VALUE>> {
        private EntrySet() {
        }

        @Override
        public Iterator<IntEntry<VALUE>> iterator() {
            return IntKeyMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof IntEntry)) {
                return false;
            }
            IntEntry e = (IntEntry)o;
            IntEntry candidate = IntKeyMap.this.getEntry(e.key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return IntKeyMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return IntKeyMap.this.size;
        }

        @Override
        public void clear() {
            IntKeyMap.this.clear();
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        IntEntry<VALUE> next;
        int expectedModCount;
        int index;
        IntEntry<VALUE> current;

        HashIterator() {
            this.expectedModCount = IntKeyMap.this.modCount;
            IntEntry<VALUE>[] t = IntKeyMap.this.table;
            int i = t.length;
            IntEntry n = null;
            if (IntKeyMap.this.size != 0) {
                while (i > 0 && (n = t[--i]) == null) {
                }
            }
            this.next = n;
            this.index = i;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        IntEntry<VALUE> nextEntry() {
            if (IntKeyMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            IntEntry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            IntEntry n = e.next;
            IntEntry<VALUE>[] t = IntKeyMap.this.table;
            int i = this.index;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.index = i;
            this.next = n;
            this.current = e;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (IntKeyMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int k = this.current.key;
            this.current = null;
            IntKeyMap.this.removeEntryForKey(k);
            this.expectedModCount = IntKeyMap.this.modCount;
        }
    }
}

