/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator.resultset;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.data.DBDResultSetDataProvider;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.generator.SQLGeneratorBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.ArrayUtils;

public abstract class SQLGeneratorResultSet
extends SQLGeneratorBase<DBDResultSetDataProvider> {
    @NotNull
    public DBDResultSetDataProvider getDataProvider() {
        return (DBDResultSetDataProvider)this.objects.getFirst();
    }

    @Override
    protected abstract void generateSQL(@NotNull DBRProgressMonitor var1, @NotNull StringBuilder var2, @NotNull DBDResultSetDataProvider var3) throws DBException;

    @Override
    @NotNull
    protected Collection<? extends DBSAttributeBase> getAllAttributes(@NotNull DBRProgressMonitor monitor, @NotNull DBDResultSetDataProvider dataProvider) throws DBException {
        return dataProvider.getVisibleAttributes();
    }

    void appendKeyConditions(@NotNull StringBuilder sql, @NotNull Collection<DBDAttributeBinding> keyAttributes, @NotNull DBDValueRow firstRow) throws DBException {
        Object firstCellValue;
        Object[] values = firstRow.getValues();
        if (!ArrayUtils.isEmpty((Object[])values) && (firstCellValue = values[0]) instanceof DBDDocument) {
            DBDDocument document = (DBDDocument)firstCellValue;
            Object idName = document.getDocumentProperty("idAttributeName");
            Object documentId = document.getDocumentId();
            if (idName != null && documentId != null) {
                sql.append(idName).append(" = ").append(SQLUtils.quoteString((DBSObject)this.getDataProvider().getSingleSource(), (String)documentId.toString()));
                return;
            }
        }
        boolean hasAttr = false;
        for (DBDAttributeBinding attr : keyAttributes) {
            if (hasAttr) {
                sql.append(" AND ");
            }
            this.appendValueCondition(this.getDataProvider(), sql, attr, firstRow);
            hasAttr = true;
        }
    }

    protected List<DBDAttributeBinding> getKeyAttributes(@NotNull DBRProgressMonitor monitor, @NotNull DBDResultSetDataProvider dataProvider) throws DBException {
        DBDRowIdentifier rowIdentifier = dataProvider.getDefaultRowIdentifier();
        if (rowIdentifier == null) {
            return Collections.emptyList();
        }
        return rowIdentifier.getAttributes();
    }

    private void appendValueCondition(@NotNull DBDResultSetDataProvider dataProvider, @NotNull StringBuilder sql, @NotNull DBDAttributeBinding binding, @NotNull DBDValueRow firstRow) throws DBException {
        Object value = dataProvider.getCellValue(binding, firstRow);
        sql.append(DBUtils.getObjectFullName((DBPNamedObject)binding.getAttribute(), (DBPEvaluationContext)DBPEvaluationContext.DML));
        if (DBUtils.isNullValue((Object)value)) {
            sql.append(" IS NULL");
        } else {
            sql.append("=");
            this.appendAttributeValue(dataProvider, sql, binding, firstRow, true);
        }
    }

    protected void appendAttributeValue(@NotNull DBDResultSetDataProvider dataProvider, @NotNull StringBuilder sql, @NotNull DBDAttributeBinding binding, @NotNull DBDValueRow row, boolean isInCondition) throws DBException {
        DBPDataSource dataSource = binding.getDataSource();
        Object value = dataProvider.getCellValue(binding, row);
        DBSAttributeBase attribute = binding.getAttribute();
        if (attribute.getDataKind() == DBPDataKind.DATETIME && this.isUseCustomDataFormat()) {
            sql.append(SQLUtils.quoteString((DBPDataSource)dataSource, (String)SQLUtils.convertValueToSQL((DBPDataSource)dataSource, (DBSTypedObject)attribute, (DBDValueHandler)DBUtils.findValueHandler((DBPDataSource)dataSource, (DBSTypedObject)attribute), (Object)value, (DBDDisplayFormat)DBDDisplayFormat.UI, (boolean)isInCondition)));
        } else {
            sql.append(SQLUtils.convertValueToSQL((DBPDataSource)dataSource, (DBSTypedObject)attribute, (Object)value));
        }
    }
}

