/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLParameterToken;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;

public class ScriptParameterRule
implements TPRule {
    private final SQLSyntaxManager syntaxManager;
    private final SQLParameterToken parameterToken;
    private final StringBuilder buffer;
    private final char anonymousParameterMark;
    private final String namedParameterPrefix;
    private final String[][] quoteStrings;

    public ScriptParameterRule(SQLSyntaxManager syntaxManager, SQLParameterToken parameterToken, String prefix) {
        this.syntaxManager = syntaxManager;
        this.parameterToken = parameterToken;
        this.buffer = new StringBuilder();
        this.anonymousParameterMark = syntaxManager.getAnonymousParameterMark();
        this.namedParameterPrefix = prefix;
        this.quoteStrings = syntaxManager.getIdentifierQuoteStrings();
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        scanner.unread();
        int prevChar = scanner.read();
        char namedPrefix = this.namedParameterPrefix.charAt(0);
        if (ScriptParameterRule.isValidParameterChar((char)prevChar) || prevChar == namedPrefix || prevChar == this.anonymousParameterMark || prevChar == 92 || prevChar == 47 || prevChar == 91 && namedPrefix == ':') {
            return TPTokenAbstract.UNDEFINED;
        }
        int c = scanner.read();
        if (c != -1 && (c == this.anonymousParameterMark || c == namedPrefix)) {
            this.buffer.setLength(0);
            this.buffer.append((char)c);
            c = scanner.read();
            if (ScriptParameterRule.isIdentifierQuote((char)c, true, false, this.quoteStrings)) {
                do {
                    this.buffer.append((char)c);
                    c = scanner.read();
                    if (!ScriptParameterRule.isIdentifierQuote((char)c, false, true, this.quoteStrings)) continue;
                    this.buffer.append((char)c);
                    c = scanner.read();
                    break;
                } while (c != -1);
            } else {
                while (c != -1 && ScriptParameterRule.isValidParameterChar((char)c)) {
                    this.buffer.append((char)c);
                    c = scanner.read();
                }
            }
            scanner.unread();
            if (this.syntaxManager.isAnonymousParametersEnabled() && this.buffer.length() == 1 && this.buffer.charAt(0) == this.anonymousParameterMark) {
                return this.parameterToken;
            }
            if (this.syntaxManager.isParametersEnabled() && this.buffer.charAt(0) == namedPrefix && this.buffer.length() > 1) {
                if (ScriptParameterRule.isIdentifierQuote(this.buffer.charAt(1), true, false, this.quoteStrings) && ScriptParameterRule.isIdentifierQuote(this.buffer.charAt(this.buffer.length() - 1), false, true, this.quoteStrings) && this.buffer.length() > 3) {
                    return this.parameterToken;
                }
                boolean validChars = true;
                for (int i = 1; i < this.buffer.length(); ++i) {
                    if (ScriptParameterRule.isValidParameterChar(this.buffer.charAt(i))) continue;
                    validChars = false;
                    break;
                }
                if (validChars) {
                    return this.parameterToken;
                }
            }
            for (int i = this.buffer.length() - 1; i >= 0; --i) {
                scanner.unread();
            }
        } else {
            scanner.unread();
        }
        return TPTokenAbstract.UNDEFINED;
    }

    private static boolean isValidParameterChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static int tryConsumeParameterName(@NotNull SQLDialect sqlDialect, @NotNull CharSequence buffer, int position) {
        int endPos = ScriptParameterRule.tryConsumeParameterNameImpl(sqlDialect, buffer, position);
        return endPos > position ? endPos : -1;
    }

    private static int tryConsumeParameterNameImpl(@NotNull SQLDialect sqlDialect, @NotNull CharSequence buffer, int position) {
        String[][] quoteStrings = sqlDialect.getIdentifierQuoteStrings();
        int c = position < buffer.length() ? (int)buffer.charAt(position) : -1;
        ++position;
        if (ScriptParameterRule.isIdentifierQuote((char)c, true, false, quoteStrings)) {
            do {
                c = position < buffer.length() ? (int)buffer.charAt(position) : -1;
                ++position;
                if (!ScriptParameterRule.isIdentifierQuote((char)c, false, true, quoteStrings)) continue;
                c = position < buffer.length() ? (int)buffer.charAt(position) : -1;
                ++position;
                break;
            } while (c != -1);
        } else {
            while (c != -1 && ScriptParameterRule.isValidParameterChar((char)c)) {
                c = position < buffer.length() ? (int)buffer.charAt(position) : -1;
                ++position;
            }
        }
        return position - 1;
    }

    private static boolean isIdentifierQuote(char c, boolean testStart, boolean testEnd, String[][] quoteStrings) {
        String testStr = Character.toString(c);
        if (testStr.equals("\"")) {
            return true;
        }
        if (quoteStrings != null) {
            for (String[] quotePair : quoteStrings) {
                if ((!testStart || !testStr.equals(quotePair[0])) && (!testEnd || !testStr.equals(quotePair[1]))) continue;
                return true;
            }
        }
        return false;
    }
}

