/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.dml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryUpdateSetClauseModel;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueColumnReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMUtils;

public class SQLQueryUpdateModel
extends SQLQueryModelContent {
    @Nullable
    private final SQLQueryRowsSourceModel targetRows;
    @Nullable
    private final List<SQLQueryUpdateSetClauseModel> setClauseList;
    @Nullable
    private final SQLQueryRowsSourceModel sourceRows;
    @Nullable
    private final SQLQueryValueExpression whereClause;
    @Nullable
    private final SQLQueryValueExpression orderByClause;
    @Nullable
    private final SQLQueryLexicalScope targetsScope;
    @Nullable
    private final SQLQueryLexicalScope conditionsScope;
    @Nullable
    private final SQLQueryLexicalScope tailScope;

    public SQLQueryUpdateModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryRowsSourceModel targetRows, @Nullable List<SQLQueryUpdateSetClauseModel> setClauseList, @Nullable SQLQueryRowsSourceModel sourceRows, @Nullable SQLQueryValueExpression whereClause, @Nullable SQLQueryValueExpression orderByClause, @Nullable SQLQueryLexicalScope targetsScope, @Nullable SQLQueryLexicalScope conditionsScope, @Nullable SQLQueryLexicalScope tailScope) {
        super(syntaxNode.getRealInterval(), syntaxNode, new SQLQueryNodeModel[0]);
        this.targetRows = targetRows;
        this.setClauseList = setClauseList;
        this.sourceRows = sourceRows;
        this.whereClause = whereClause;
        this.orderByClause = orderByClause;
        this.targetsScope = targetsScope;
        this.conditionsScope = conditionsScope;
        this.tailScope = tailScope;
        if (targetsScope != null) {
            this.registerLexicalScope(targetsScope);
        }
        if (conditionsScope != null) {
            this.registerLexicalScope(conditionsScope);
        }
    }

    @NotNull
    public static SQLQueryModelContent recognize(@NotNull SQLQueryModelRecognizer recognizer, @NotNull STMTreeNode node) {
        SQLQueryLexicalScope tailScope;
        SQLQueryValueExpression orderByExpr;
        SQLQueryValueExpression whereClauseExpr;
        SQLQueryLexicalScope conditionsScope;
        STMTreeNode fromClauseNode;
        SQLQueryLexicalScope targetsScope;
        STMTreeNode targetTableNode = node.findFirstChildOfName(STMKnownRuleNames.tableReference);
        SQLQueryRowsSourceModel targetSet = targetTableNode == null ? null : recognizer.collectQueryExpression(targetTableNode);
        STMTreeNode setTermNode = node.findFirstChildOfName(STMKnownRuleNames.SET_TERM);
        Interval targetsScopeInterval = Interval.of((int)(setTermNode != null ? setTermNode.getRealInterval().b + 2 : Integer.MAX_VALUE), (int)Integer.MAX_VALUE);
        ArrayList<SQLQueryUpdateSetClauseModel> setClauseList = new ArrayList<SQLQueryUpdateSetClauseModel>();
        STMTreeNode setClauseListNode = node.findFirstChildOfName(STMKnownRuleNames.setClauseList);
        if (setClauseListNode != null) {
            try (SQLQueryModelRecognizer.LexicalScopeHolder holder = recognizer.openScope();){
                targetsScope = holder.lexicalScope;
                for (STMTreeNode setClauseNode : setClauseListNode.findChildrenOfName(STMKnownRuleNames.setClause)) {
                    List<SQLQueryValueExpression> list;
                    STMTreeNode setTargetNode = setClauseNode.findFirstNonErrorChild();
                    if (setTargetNode == null) {
                        list = Collections.emptyList();
                    } else {
                        switch (setTargetNode.getNodeKindId()) {
                            case 252: {
                                STMTreeNode targetNameNode = setTargetNode.findFirstNonErrorChild();
                                SQLQuerySymbolEntry targetName = targetNameNode == null ? null : recognizer.collectIdentifier(targetNameNode, null);
                                list = List.of(new SQLQueryValueColumnReferenceExpression(setTargetNode, targetName));
                                break;
                            }
                            case 253: {
                                list = STMUtils.expandSubtree((STMTreeNode)setTargetNode, Set.of(STMKnownRuleNames.setTargetList), Set.of(STMKnownRuleNames.valueReference)).stream().map(cn -> recognizer.collectValueExpression((STMTreeNode)cn, targetsScope)).collect(Collectors.toList());
                                break;
                            }
                            case 286: {
                                list = Collections.emptyList();
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("Set target list expected while facing with " + setTargetNode.getNodeName());
                            }
                        }
                    }
                    List<SQLQueryValueExpression> targets = list;
                    STMTreeNode updateSourceNode = setClauseNode.findFirstChildOfName(STMKnownRuleNames.updateSource);
                    List<SQLQueryValueExpression> sources = updateSourceNode == null ? Collections.emptyList() : STMUtils.expandSubtree((STMTreeNode)updateSourceNode, Set.of(STMKnownRuleNames.updateSource), Set.of(STMKnownRuleNames.updateValue)).stream().map(STMTreeNode::findFirstNonErrorChild).filter(Objects::nonNull).map(cn -> recognizer.collectValueExpression((STMTreeNode)cn, targetsScope)).collect(Collectors.toList());
                    setClauseList.add(new SQLQueryUpdateSetClauseModel(setClauseNode, targets, sources, setClauseNode.getTextContent()));
                }
            }
        } else {
            targetsScope = null;
        }
        SQLQueryRowsSourceModel sourceSet = (fromClauseNode = node.findFirstChildOfName(STMKnownRuleNames.fromClause)) == null ? null : recognizer.collectQueryExpression(fromClauseNode);
        STMTreeNode whereClauseNode = node.findFirstChildOfName(STMKnownRuleNames.whereClause);
        STMTreeNode orderByClauseNode = node.findFirstChildOfName(STMKnownRuleNames.orderByClause);
        STMTreeNode limitClauseNode = node.findFirstChildOfName(STMKnownRuleNames.limitClause);
        if (whereClauseNode != null || orderByClauseNode != null) {
            int to;
            int from;
            try (SQLQueryModelRecognizer.LexicalScopeHolder holder = recognizer.openScope();){
                conditionsScope = holder.lexicalScope;
                whereClauseExpr = whereClauseNode == null ? null : recognizer.collectValueExpression(whereClauseNode, conditionsScope);
                orderByExpr = orderByClauseNode == null ? null : recognizer.collectValueExpression(orderByClauseNode, conditionsScope);
            }
            STMTreeNode lastConditionKwNode = (whereClauseNode != null ? whereClauseNode : orderByClauseNode).findFirstNonErrorChild();
            int n = from = lastConditionKwNode != null ? lastConditionKwNode.getRealInterval().b + 2 : whereClauseNode.getRealInterval().a;
            if (limitClauseNode != null) {
                to = limitClauseNode.getRealInterval().a;
                tailScope = null;
            } else {
                to = Integer.MAX_VALUE;
                tailScope = conditionsScope;
            }
            conditionsScope.setInterval(Interval.of((int)from, (int)to));
        } else {
            whereClauseExpr = null;
            orderByExpr = null;
            conditionsScope = null;
            SQLQueryLexicalScope sQLQueryLexicalScope = tailScope = limitClauseNode == null ? targetsScope : null;
        }
        if (targetsScope != null) {
            STMTreeNode firstConditionNode;
            Object object = whereClauseNode != null ? whereClauseNode : (orderByClauseNode != null ? orderByClauseNode : (firstConditionNode = limitClauseNode != null ? limitClauseNode : null));
            if (firstConditionNode != null) {
                targetsScopeInterval.b = firstConditionNode.getRealInterval().a - 1;
            }
            targetsScope.setInterval(targetsScopeInterval);
        }
        return new SQLQueryUpdateModel(node, targetSet, setClauseList, sourceSet, whereClauseExpr, orderByExpr, targetsScope, conditionsScope, tailScope);
    }

    @Nullable
    public SQLQueryRowsSourceModel getTargetRows() {
        return this.targetRows;
    }

    @Nullable
    public List<SQLQueryUpdateSetClauseModel> getSetClauseList() {
        return this.setClauseList;
    }

    @Nullable
    public SQLQueryRowsSourceModel getSourceRows() {
        return this.sourceRows;
    }

    @Nullable
    public SQLQueryValueExpression getWhereClause() {
        return this.whereClause;
    }

    @Nullable
    public SQLQueryValueExpression getOrderByClause() {
        return this.orderByClause;
    }

    @Override
    public void resolveObjectAndRowsReferences(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryRowsSourceContext sourceContext;
        SQLQueryRowsSourceContext targetContext;
        if (this.targetRows != null) {
            targetContext = this.targetRows.resolveRowSources(context, statistics);
            if (this.setClauseList != null) {
                for (SQLQueryUpdateSetClauseModel updateSetClauseModel : this.setClauseList) {
                    for (SQLQueryValueExpression valueExpression : updateSetClauseModel.targets) {
                        valueExpression.resolveRowSources(targetContext, statistics);
                    }
                }
            }
        } else {
            targetContext = context;
        }
        SQLQueryRowsSourceContext sQLQueryRowsSourceContext = sourceContext = this.sourceRows != null ? this.sourceRows.resolveRowSources(context, statistics) : context;
        if (targetContext != context || sourceContext != context) {
            context = targetContext.combine(sourceContext);
        }
        if (this.setClauseList != null) {
            for (SQLQueryUpdateSetClauseModel setClauseModel : this.setClauseList) {
                for (SQLQueryValueExpression valueExpression : setClauseModel.sources) {
                    valueExpression.resolveRowSources(context, statistics);
                }
            }
        }
        if (this.whereClause != null) {
            this.whereClause.resolveRowSources(context, statistics);
        }
        if (this.orderByClause != null) {
            this.orderByClause.resolveRowSources(context, statistics);
        }
    }

    @Override
    public void resolveValueRelations(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryRowsDataContext sourceContext;
        SQLQueryRowsDataContext targetContext;
        if (this.targetRows != null) {
            this.targetRows.resolveValueRelations(context, statistics);
            targetContext = this.targetRows.getRowsDataContext();
            if (this.targetsScope != null) {
                this.targetsScope.setSymbolsOrigin(new SQLQuerySymbolOrigin.SyntaxBasedFromRowsData(targetContext));
            }
            if (this.setClauseList != null) {
                for (SQLQueryUpdateSetClauseModel updateSetClauseModel : this.setClauseList) {
                    for (SQLQueryValueExpression valueExpression : updateSetClauseModel.targets) {
                        valueExpression.resolveValueRelations(targetContext, statistics);
                    }
                }
            }
        } else {
            targetContext = context;
        }
        if (this.sourceRows != null) {
            this.sourceRows.resolveValueRelations(context, statistics);
            sourceContext = this.sourceRows.getRowsDataContext();
        } else {
            sourceContext = context;
        }
        if (targetContext != context || sourceContext != context) {
            context = targetContext.combine(sourceContext);
        }
        if (this.setClauseList != null) {
            for (SQLQueryUpdateSetClauseModel setClauseModel : this.setClauseList) {
                for (SQLQueryValueExpression valueExpression : setClauseModel.sources) {
                    valueExpression.resolveValueRelations(context, statistics);
                }
            }
        }
        if (this.whereClause != null) {
            this.whereClause.resolveValueRelations(context, statistics);
        }
        if (this.orderByClause != null) {
            this.orderByClause.resolveValueRelations(context, statistics);
        }
        if (this.conditionsScope != null) {
            this.conditionsScope.setSymbolsOrigin(new SQLQuerySymbolOrigin.RowsDataRef(context));
        }
        if (this.tailScope != null) {
            this.setTailOrigin(this.tailScope.getSymbolsOrigin());
        }
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitTableStatementUpdate(this, arg);
    }
}

