/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.text.parser.rules;

import java.util.Arrays;
import java.util.Comparator;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPPredicateRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;

public class PatternRule
implements TPPredicateRule {
    protected static final int UNDEFINED = -1;
    protected TPToken fToken;
    protected char[] fStartSequence;
    protected char[] fEndSequence;
    protected int fColumn = -1;
    protected char fEscapeCharacter;
    protected boolean fEscapeContinuesLine;
    protected boolean fBreaksOnEOL;
    protected boolean fBreaksOnEOF;
    protected boolean fExcludeLineDelimiter;
    private Comparator<char[]> fLineDelimiterComparator = new DecreasingCharArrayLengthComparator();
    private char[][] fLineDelimiters;
    private char[][] fSortedLineDelimiters;

    public PatternRule(String startSequence, String endSequence, TPToken token, char escapeCharacter, boolean breaksOnEOL) {
        this.fStartSequence = startSequence.toCharArray();
        this.fEndSequence = endSequence == null ? new char[]{} : endSequence.toCharArray();
        this.fToken = token;
        this.fEscapeCharacter = escapeCharacter;
        this.fBreaksOnEOL = breaksOnEOL;
    }

    public PatternRule(String startSequence, String endSequence, TPToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF) {
        this(startSequence, endSequence, token, escapeCharacter, breaksOnEOL);
        this.fBreaksOnEOF = breaksOnEOF;
    }

    public PatternRule(String startSequence, String endSequence, TPToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF, boolean escapeContinuesLine) {
        this(startSequence, endSequence, token, escapeCharacter, breaksOnEOL, breaksOnEOF);
        this.fEscapeContinuesLine = escapeContinuesLine;
    }

    public PatternRule(String startSequence, String endSequence, TPToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF, boolean escapeContinuesLine, boolean excludeLineDelimiter) {
        this(startSequence, endSequence, token, escapeCharacter, breaksOnEOL, breaksOnEOF);
        this.fEscapeContinuesLine = escapeContinuesLine;
        this.fExcludeLineDelimiter = excludeLineDelimiter;
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    protected TPToken doEvaluate(TPCharacterScanner scanner) {
        return this.doEvaluate(scanner, false);
    }

    protected TPToken doEvaluate(TPCharacterScanner scanner, boolean resume) {
        int c;
        if (resume ? this.endSequenceDetected(scanner) : (c = scanner.read()) == this.fStartSequence[0] && this.sequenceDetected(scanner, this.fStartSequence, false) && this.endSequenceDetected(scanner)) {
            return this.fToken;
        }
        scanner.unread();
        return TPTokenAbstract.UNDEFINED;
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    protected boolean endSequenceDetected(TPCharacterScanner scanner) {
        int c;
        int count;
        char[][] originalDelimiters = scanner.getLegalLineDelimiters();
        if (this.fLineDelimiters == null || this.fLineDelimiters.length != count) {
            this.fSortedLineDelimiters = new char[count][];
        } else {
            for (count = originalDelimiters.length; count > 0 && Arrays.equals(this.fLineDelimiters[count - 1], originalDelimiters[count - 1]); --count) {
            }
        }
        if (count != 0) {
            this.fLineDelimiters = originalDelimiters;
            System.arraycopy(this.fLineDelimiters, 0, this.fSortedLineDelimiters, 0, this.fLineDelimiters.length);
            Arrays.sort(this.fSortedLineDelimiters, this.fLineDelimiterComparator);
        }
        int readCount = 1;
        while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                if (this.fEscapeContinuesLine) {
                    char[] fSortedLineDelimiter;
                    c = scanner.read();
                    char[][] cArray = this.fSortedLineDelimiters;
                    int n = cArray.length;
                    for (int i = 0; !(i >= n || c == (fSortedLineDelimiter = cArray[i])[0] && this.sequenceDetected(scanner, fSortedLineDelimiter, this.fBreaksOnEOF)); ++i) {
                    }
                } else {
                    scanner.read();
                }
            } else if (this.fEndSequence.length > 0 && c == this.fEndSequence[0]) {
                if (this.sequenceDetected(scanner, this.fEndSequence, this.fBreaksOnEOF)) {
                    return true;
                }
            } else if (this.fBreaksOnEOL) {
                for (char[] fSortedLineDelimiter : this.fSortedLineDelimiters) {
                    if (c != fSortedLineDelimiter[0] || !this.sequenceDetected(scanner, fSortedLineDelimiter, this.fBreaksOnEOF)) continue;
                    if (this.fExcludeLineDelimiter) {
                        for (int i = 0; i < fSortedLineDelimiter.length; ++i) {
                            scanner.unread();
                        }
                    }
                    return true;
                }
            }
            ++readCount;
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        while (readCount > 0) {
            scanner.unread();
            --readCount;
        }
        return false;
    }

    protected boolean sequenceDetected(TPCharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        for (int i = 1; i < sequence.length; ++i) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (c == sequence[i]) continue;
            scanner.unread();
            for (int j = i - 1; j > 0; --j) {
                scanner.unread();
            }
            return false;
        }
        return true;
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner, boolean resume) {
        if (this.fColumn == -1) {
            return this.doEvaluate(scanner, resume);
        }
        int c = scanner.read();
        scanner.unread();
        if (c == this.fStartSequence[0]) {
            return this.fColumn == scanner.getColumn() ? this.doEvaluate(scanner, resume) : TPTokenAbstract.UNDEFINED;
        }
        return TPTokenAbstract.UNDEFINED;
    }

    @Override
    public TPToken getSuccessToken() {
        return this.fToken;
    }

    private static class DecreasingCharArrayLengthComparator
    implements Comparator<char[]> {
        private DecreasingCharArrayLengthComparator() {
        }

        @Override
        public int compare(char[] o1, char[] o2) {
            return o2.length - o1.length;
        }
    }
}

