/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.variables;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.commands.SQLCommandSet;
import org.jkiss.dbeaver.model.sql.parser.rules.ScriptParameterRule;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class AssignVariableAction
extends Action {
    protected static final Log log = Log.getLog(AssignVariableAction.class);
    private final SQLEditor editor;
    private final String queryText;
    private boolean isQuery = false;
    private boolean isEditable = true;
    private boolean checkDuplicates = true;
    private SQLEditorBase valueEditor;
    private String varValue;

    public AssignVariableAction(SQLEditor editor, String varValue) {
        super(SQLEditorMessages.action_result_tabs_assign_variable);
        this.editor = editor;
        this.queryText = varValue;
    }

    public void setQuery(boolean query) {
        this.isQuery = query;
    }

    public void setEditable(boolean editable) {
        this.isEditable = editable;
    }

    public void setCheckDuplicates(boolean checkDuplicates) {
        this.checkDuplicates = checkDuplicates;
    }

    public void run() {
        EnterNameDialog dialog = new EnterNameDialog(this.editor.getEditorControlWrapper().getShell(), this.isQuery ? SQLEditorMessages.action_result_tabs_assign_variable_sql : SQLEditorMessages.action_result_tabs_assign_variable, ""){
            private String varName;
            {
                this.varName = null;
            }

            @Nullable
            public String getResult() {
                return this.varName;
            }

            protected IDialogSettings getDialogBoundsSettings() {
                return UIUtils.getDialogSettings((String)"DBeaver.SQLEditor.AssignVariableDialog");
            }

            protected Composite createDialogArea(Composite parent) {
                Composite area = super.createDialogArea(parent);
                AssignVariableAction.this.valueEditor = new SQLEditorBase(){

                    @Nullable
                    public DBCExecutionContext getExecutionContext() {
                        return AssignVariableAction.this.editor.getExecutionContext();
                    }
                };
                try {
                    AssignVariableAction.this.valueEditor.init((IEditorSite)new SubEditorSite(AssignVariableAction.this.editor.getSite()), (IEditorInput)new StringEditorInput("Variable value", (CharSequence)AssignVariableAction.this.queryText, !AssignVariableAction.this.isEditable, GeneralUtils.getDefaultFileEncoding()));
                }
                catch (PartInitException e) {
                    log.error((Object)e);
                }
                Composite editorPH = UIUtils.createComposite((Composite)area, (int)1);
                editorPH.setLayoutData((Object)new GridData(1808));
                UIUtils.createControlLabel((Composite)editorPH, (String)(AssignVariableAction.this.isQuery ? "Query" : "Value"));
                AssignVariableAction.this.valueEditor.createPartControl(editorPH);
                AssignVariableAction.this.valueEditor.getEditorControlWrapper().setLayoutData(new GridData(1808));
                AssignVariableAction.this.valueEditor.setWordWrap(true);
                AssignVariableAction.this.valueEditor.reloadSyntaxRules();
                UIUtils.asyncExec(() -> this.propNameText.setFocus());
                return area;
            }

            protected void okPressed() {
                String rawVarName;
                SQLDialect sqlDialect = AssignVariableAction.this.editor.getSQLDialect();
                if (ScriptParameterRule.tryConsumeParameterName((SQLDialect)sqlDialect, (CharSequence)(rawVarName = this.propNameText.getText().trim()), (int)0) != rawVarName.length()) {
                    UIUtils.showMessageBox((Shell)this.getShell(), (String)SQLEditorMessages.action_assign_variables_error_invalid_title, (String)NLS.bind((String)SQLEditorMessages.action_assign_variables_error_invalid_info, (Object)rawVarName), (int)1);
                    this.varName = null;
                    return;
                }
                String preparedVarName = SQLCommandSet.prepareVarName((SQLDialect)sqlDialect, (String)rawVarName);
                if (AssignVariableAction.this.checkDuplicates && AssignVariableAction.this.editor.getGlobalScriptContext().hasVariable(preparedVarName)) {
                    UIUtils.showMessageBox((Shell)this.getShell(), (String)SQLEditorMessages.action_assign_variables_error_duplicated_title, (String)NLS.bind((String)SQLEditorMessages.action_assign_variables_error_duplicated_info, (Object)preparedVarName), (int)1);
                    this.varName = null;
                    return;
                }
                this.varName = preparedVarName;
                AssignVariableAction.this.varValue = AssignVariableAction.this.valueEditor.getEditorControl().getText();
                super.okPressed();
            }

            protected void updateButtonsState() {
                super.updateButtonsState();
                Button button = this.getButton(0);
                if (button != null && this.propNameText != null && button.getEnabled()) {
                    String rawVarName = this.propNameText.getText().trim();
                    int consumedNameLength = ScriptParameterRule.tryConsumeParameterName((SQLDialect)AssignVariableAction.this.editor.getSQLDialect(), (CharSequence)rawVarName, (int)0);
                    button.setEnabled(consumedNameLength == rawVarName.length());
                }
            }
        };
        if (dialog.open() == 0) {
            this.editor.getGlobalScriptContext().setVariable(dialog.getResult(), (Object)this.varValue);
        }
    }
}

