/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.editor.tools;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ui.editors.erd.internal.ERDUIMessages;
import org.jkiss.dbeaver.ui.editors.erd.part.ICustomizablePart;

public class ResetPartColorAction
extends SelectionAction {
    private IStructuredSelection selection;

    public ResetPartColorAction(ERDEditorPart part, IStructuredSelection selection) {
        super((IWorkbenchPart)part);
        this.selection = selection;
        this.setText(ERDUIMessages.erd_tool_color_action_text_reset_color);
        this.setToolTipText(ERDUIMessages.erd_tool_color_action_tip_text_reset_figure_color);
        this.setId("removeFigureColor");
    }

    protected boolean calculateEnabled() {
        for (Object item : this.selection.toArray()) {
            if (!(item instanceof ICustomizablePart) || ((ICustomizablePart)item).getCustomBackgroundColor() == null) continue;
            return true;
        }
        return false;
    }

    protected void init() {
        super.init();
    }

    public void run() {
        this.execute(this.createColorCommand(this.selection.toArray()));
    }

    private Command createColorCommand(final Object[] objects) {
        return new Command(this){
            private final Map<ICustomizablePart, Color> oldColors = new HashMap<ICustomizablePart, Color>();

            public void execute() {
                for (Object item : objects) {
                    if (!(item instanceof ICustomizablePart)) continue;
                    ICustomizablePart colorizedPart = (ICustomizablePart)item;
                    this.oldColors.put(colorizedPart, colorizedPart.getCustomBackgroundColor());
                    colorizedPart.setCustomBackgroundColor(null);
                }
            }

            public void undo() {
                for (Object item : objects) {
                    if (!(item instanceof ICustomizablePart)) continue;
                    ICustomizablePart colorizedPart = (ICustomizablePart)item;
                    colorizedPart.setCustomBackgroundColor(this.oldColors.get(colorizedPart));
                }
            }

            public void redo() {
                for (Object item : objects) {
                    if (!(item instanceof ICustomizablePart)) continue;
                    ICustomizablePart colorizedPart = (ICustomizablePart)item;
                    colorizedPart.setCustomBackgroundColor(null);
                }
            }
        };
    }
}

