/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cts.CRSFactory;
import org.cts.crs.CoordinateReferenceSystem;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.gis.GisTransformUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.gis.internal.GISMessages;
import org.jkiss.dbeaver.ui.internal.UIActivator;

public class ManageCRSDialog
extends BaseDialog {
    private static final Log log = Log.getLog(ManageCRSDialog.class);
    private static final String DIALOG_ID = "DBeaver.ManageCRSDialog";
    private int selectedSRID;
    private static CRSLoader crsLoader;

    public ManageCRSDialog(Shell shell, int defCRS) {
        super(shell, GISMessages.panel_manage_crs_dialog_title_select_system, null);
        this.selectedSRID = defCRS;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getSettingsSection((IDialogSettings)UIActivator.getDefault().getDialogSettings(), (String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        if (crsLoader == null) {
            crsLoader = new CRSLoader(this);
            try {
                UIUtils.runInProgressDialog((DBRRunnableWithProgress)crsLoader);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Error loading CRS list", e.getTargetException());
            }
        }
        PatternFilter patternFilter = new PatternFilter(this){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                if (element instanceof CRSInfo) {
                    return this.wordMatches(((CRSInfo)element).name) || this.wordMatches(String.valueOf(((CRSInfo)element).code)) || this.wordMatches(((CRSInfo)element).coordSystemName) || this.wordMatches(((CRSInfo)element).projectionName);
                }
                return super.isLeafMatch(viewer, element);
            }
        };
        TreeViewer treeViewer = DialogUtils.createFilteredTree((Composite)dialogArea, (int)67584, (PatternFilter)patternFilter, null);
        final Tree crsTree = treeViewer.getTree();
        crsTree.setLayoutData((Object)new GridData(1808));
        crsTree.setHeaderVisible(true);
        UIUtils.createTreeColumn((Tree)crsTree, (int)16384, (String)GISMessages.panel_manage_crs_dialog_tree_column_text_name);
        UIUtils.createTreeColumn((Tree)crsTree, (int)16384, (String)GISMessages.panel_manage_crs_dialog_tree_column_text_srid);
        UIUtils.createTreeColumn((Tree)crsTree, (int)16384, (String)GISMessages.panel_manage_crs_dialog_tree_column_text_coordinate_system);
        UIUtils.createTreeColumn((Tree)crsTree, (int)16384, (String)GISMessages.panel_manage_crs_dialog_tree_column_text_projection);
        treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement == crsLoader) {
                    return ManageCRSDialog.crsLoader.crsMap.keySet().toArray(new Object[0]);
                }
                if (parentElement instanceof String) {
                    List<CRSInfo> crsInfos = ManageCRSDialog.crsLoader.crsMap.get(parentElement);
                    return crsInfos == null ? null : crsInfos.toArray(new Object[0]);
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof String) {
                    return crsTree;
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element == crsLoader) {
                    return !ManageCRSDialog.crsLoader.crsMap.isEmpty();
                }
                if (element instanceof String) {
                    List<CRSInfo> crsInfos = ManageCRSDialog.crsLoader.crsMap.get(element);
                    return crsInfos != null && !crsInfos.isEmpty();
                }
                return false;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }
        });
        treeViewer.setLabelProvider((IBaseLabelProvider)new CRSLabelProvider());
        treeViewer.setInput((Object)crsLoader);
        treeViewer.expandAll();
        treeViewer.addSelectionChangedListener(event -> {
            Object selElement;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (selElement = ((IStructuredSelection)selection).getFirstElement()) instanceof CRSInfo) {
                this.selectedSRID = ((CRSInfo)selElement).code;
            }
        });
        UIUtils.packColumns((Tree)crsTree, (boolean)true, null);
        return dialogArea;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateButtons();
        return contents;
    }

    private void updateButtons() {
        this.getButton(0).setEnabled(this.selectedSRID != 0);
    }

    public int getSelectedSRID() {
        return this.selectedSRID;
    }

    private class CRSLoader
    implements DBRRunnableWithProgress {
        private Map<String, List<CRSInfo>> crsMap = new LinkedHashMap<String, List<CRSInfo>>();

        private CRSLoader(ManageCRSDialog manageCRSDialog) {
        }

        public void run(DBRProgressMonitor monitor) {
            CRSFactory crsFactory = GisTransformUtils.getCRSFactory();
            String regName = "EPSG";
            List crsCodes = GisTransformUtils.getSortedEPSGCodes();
            monitor.beginTask(GISMessages.panel_manage_crs_dialog_monitor_begin_task_load_crs, crsCodes.size());
            for (Integer code : crsCodes) {
                String crsID = regName + ":" + code;
                monitor.subTask(GISMessages.panel_manage_crs_dialog_monitor_sub_task_load_crs + " " + crsID);
                try {
                    CoordinateReferenceSystem crs = crsFactory.getCRS(crsID);
                    List crsInfoList = this.crsMap.computeIfAbsent(regName, s -> new ArrayList());
                    CRSInfo crsInfo = new CRSInfo();
                    crsInfo.code = code;
                    crsInfo.name = crs.getName();
                    crsInfo.coordSystemName = crs.getCoordinateSystem().toString();
                    crsInfo.projectionName = crs.getProjection() == null ? "" : crs.getProjection().getName();
                    crsInfoList.add(crsInfo);
                }
                catch (Exception e) {
                    log.debug((Object)("Error loading CRS " + code + ": " + e.getMessage()));
                }
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                break;
            }
            monitor.done();
        }
    }

    private static class CRSLabelProvider
    extends CellLabelProvider
    implements ILabelProvider {
        private CRSLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof String) {
                if (cell.getColumnIndex() == 0) {
                    cell.setText(element.toString());
                }
            } else {
                CRSInfo crsInfo = (CRSInfo)element;
                switch (cell.getColumnIndex()) {
                    case 0: {
                        cell.setText(crsInfo.name);
                        break;
                    }
                    case 1: {
                        cell.setText(String.valueOf(crsInfo.code));
                        break;
                    }
                    case 2: {
                        cell.setText(crsInfo.coordSystemName);
                        break;
                    }
                    case 3: {
                        cell.setText(crsInfo.projectionName);
                    }
                }
            }
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return element.toString();
            }
            if (element instanceof CRSInfo) {
                return ((CRSInfo)element).name;
            }
            return "";
        }
    }

    private static class CRSInfo {
        int code;
        String name;
        String coordSystemName;
        String projectionName;

        private CRSInfo() {
        }
    }
}

