/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.driver.libsql;

import com.dbeaver.jdbc.driver.libsql.LibSqlException;
import com.dbeaver.jdbc.driver.libsql.LibSqlResultSetMetaData;
import com.dbeaver.jdbc.driver.libsql.LibSqlStatement;
import com.dbeaver.jdbc.driver.libsql.client.LibSqlExecutionResult;
import com.dbeaver.jdbc.model.AbstractJdbcResultSet;
import com.dbeaver.jdbc.model.AbstractJdbcStatement;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;

public class LibSqlResultSet
extends AbstractJdbcResultSet<LibSqlStatement, LibSqlResultSetMetaData> {
    @Nullable
    private final LibSqlExecutionResult result;
    private transient int cursor = 0;
    private transient boolean closed;
    private transient boolean wasNull;
    private transient Map<String, Integer> nameMap;

    public LibSqlResultSet(@NotNull LibSqlStatement statement, @Nullable LibSqlExecutionResult result) {
        super((AbstractJdbcStatement)statement, null);
        this.result = result;
    }

    @Nullable
    public LibSqlExecutionResult getResult() {
        return this.result;
    }

    private int getColumnIndex(String columnLabel) throws LibSqlException {
        Integer index;
        if (this.nameMap == null) {
            this.nameMap = new HashMap<String, Integer>();
            List<String> columns = this.result.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                this.nameMap.put(columns.get(i).toUpperCase(Locale.ENGLISH), i + 1);
            }
        }
        if ((index = this.nameMap.get(columnLabel.toUpperCase(Locale.ENGLISH))) == null) {
            throw new LibSqlException("Column '" + columnLabel + "' is not present in result set");
        }
        return index;
    }

    private Object[] getCurrentRow() throws LibSqlException {
        List<Object[]> rows = this.result.getRows();
        if (this.cursor < 1) {
            throw new LibSqlException("Fetch not started");
        }
        if (this.cursor > rows.size()) {
            throw new LibSqlException("Fetch ended");
        }
        return rows.get(this.cursor - 1);
    }

    public boolean next() throws SQLException {
        return this.cursor++ < this.result.getRows().size();
    }

    public void close() throws SQLException {
        this.closed = true;
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    public String getString(int columnIndex) throws SQLException {
        return CommonUtils.toString((Object)this.getObject(columnIndex));
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return CommonUtils.toBoolean((Object)this.getObject(columnIndex));
    }

    public byte getByte(int columnIndex) throws SQLException {
        return (byte)CommonUtils.toInt((Object)this.getObject(columnIndex));
    }

    public short getShort(int columnIndex) throws SQLException {
        return (short)CommonUtils.toInt((Object)this.getObject(columnIndex));
    }

    public int getInt(int columnIndex) throws SQLException {
        return CommonUtils.toInt((Object)this.getObject(columnIndex));
    }

    public long getLong(int columnIndex) throws SQLException {
        return CommonUtils.toLong((Object)this.getObject(columnIndex));
    }

    public float getFloat(int columnIndex) throws SQLException {
        return CommonUtils.toFloat((Object)this.getObject(columnIndex));
    }

    public double getDouble(int columnIndex) throws SQLException {
        return CommonUtils.toDouble((Object)this.getObject(columnIndex));
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Object object = this.getObject(columnIndex);
        return object == null ? null : (object instanceof BigDecimal ? (BigDecimal)object : (object instanceof Long ? BigDecimal.valueOf((Long)object) : BigDecimal.valueOf(CommonUtils.toDouble((Object)object))));
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        Object object = this.getObject(columnIndex);
        return object == null ? null : object.toString().getBytes();
    }

    public Date getDate(int columnIndex) throws SQLException {
        Object object = this.getObject(columnIndex);
        return object == null ? null : Date.valueOf(object.toString());
    }

    public Time getTime(int columnIndex) throws SQLException {
        Object object = this.getObject(columnIndex);
        return object == null ? null : Time.valueOf(object.toString());
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object object = this.getObject(columnIndex);
        return object == null ? null : Timestamp.valueOf(object.toString());
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public String getString(String columnLabel) throws SQLException {
        return CommonUtils.toString((Object)this.getObject(columnLabel));
    }

    public boolean getBoolean(String columnLabel) throws SQLException {
        return CommonUtils.toBoolean((Object)this.getObject(columnLabel));
    }

    public byte getByte(String columnLabel) throws SQLException {
        return (byte)CommonUtils.toInt((Object)this.getObject(columnLabel));
    }

    public short getShort(String columnLabel) throws SQLException {
        return (short)CommonUtils.toInt((Object)this.getObject(columnLabel));
    }

    public int getInt(String columnLabel) throws SQLException {
        return CommonUtils.toInt((Object)this.getObject(columnLabel));
    }

    public long getLong(String columnLabel) throws SQLException {
        return CommonUtils.toLong((Object)this.getObject(columnLabel));
    }

    public float getFloat(String columnLabel) throws SQLException {
        return CommonUtils.toFloat((Object)this.getObject(columnLabel));
    }

    public double getDouble(String columnLabel) throws SQLException {
        return CommonUtils.toDouble((Object)this.getObject(columnLabel));
    }

    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        Object object = this.getObject(columnLabel);
        return object == null ? null : (object instanceof BigDecimal ? (BigDecimal)object : (object instanceof Long ? BigDecimal.valueOf((Long)object) : BigDecimal.valueOf(CommonUtils.toDouble((Object)object))));
    }

    public byte[] getBytes(String columnLabel) throws SQLException {
        Object object = this.getObject(columnLabel);
        return object == null ? null : object.toString().getBytes();
    }

    public Date getDate(String columnLabel) throws SQLException {
        Object object = this.getObject(columnLabel);
        return object == null ? null : Date.valueOf(object.toString());
    }

    public Time getTime(String columnLabel) throws SQLException {
        Object object = this.getObject(columnLabel);
        return object == null ? null : Time.valueOf(object.toString());
    }

    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        Object object = this.getObject(columnLabel);
        return object == null ? null : Timestamp.valueOf(object.toString());
    }

    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public LibSqlResultSetMetaData getMetaData() throws SQLException {
        if (this.metadata == null) {
            this.metadata = new LibSqlResultSetMetaData(this);
        }
        return (LibSqlResultSetMetaData)this.metadata;
    }

    public Object getObject(int columnIndex) throws SQLException {
        Object[] currentRow = this.getCurrentRow();
        if (columnIndex < 1 || columnIndex > currentRow.length) {
            throw new LibSqlException("Column index " + columnIndex + " is beyond range (1-" + currentRow.length + ")");
        }
        Object value = currentRow[columnIndex - 1];
        this.wasNull = value == null;
        return value;
    }

    public Object getObject(String columnLabel) throws SQLException {
        int index = this.getColumnIndex(columnLabel);
        return this.getObject(index);
    }

    public int findColumn(String columnLabel) throws SQLException {
        return this.getColumnIndex(columnLabel);
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }
}

