/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.edit;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandAggregator;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandFilter;
import org.jkiss.dbeaver.model.edit.DBECommandListener;
import org.jkiss.dbeaver.model.edit.DBECommandQueue;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBECommandRename;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractCommandContext
implements DBECommandContext {
    private static final Log log = Log.getLog(AbstractCommandContext.class);
    private final DBCExecutionContext executionContext;
    private final List<CommandInfo> commands = new ArrayList<CommandInfo>();
    private final List<CommandInfo> undidCommands = new ArrayList<CommandInfo>();
    private List<CommandQueue> commandQueues;
    private final Map<Object, Object> userParams = new HashMap<Object, Object>();
    private final List<DBECommandListener> listeners = new ArrayList<DBECommandListener>();
    private final boolean atomic;

    public AbstractCommandContext(DBCExecutionContext executionContext, boolean atomic) {
        this.executionContext = executionContext;
        this.atomic = atomic;
    }

    @Override
    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirty() {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            for (CommandQueue queue : this.getCommandQueues()) {
                if (queue.isEmpty()) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public void saveChanges(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (!this.executionContext.isConnected()) {
            this.executionContext.invalidateContext(monitor);
            if (!this.executionContext.isConnected()) {
                throw new DBException("Context [" + this.executionContext.getContextName() + "] isn't connected to the database");
            }
        }
        DBCTransactionManager txnManager = DBUtils.getTransactionManager(this.executionContext);
        HashMap<String, Object> validateOptions = new HashMap<String, Object>();
        for (CommandQueue queue : this.getCommandQueues()) {
            for (CommandInfo cmd : queue.commands) {
                cmd.command.validateCommand(monitor, validateOptions);
            }
        }
        boolean useAutoCommit = CommonUtils.getOption(validateOptions, (String)"avoidTransactions");
        if (!this.executionContext.getDataSource().getInfo().supportsTransactionsForDDL()) {
            txnManager = null;
        }
        boolean oldAutoCommit = false;
        if (txnManager != null && txnManager.isSupportsTransactions() && (oldAutoCommit = txnManager.isAutoCommit()) != useAutoCommit) {
            try {
                txnManager.setAutoCommit(monitor, useAutoCommit);
            }
            catch (DBCException e) {
                log.warn("Can't switch to transaction mode", e);
            }
        }
        try {
            this.executeCommands(monitor, options, useAutoCommit ? null : txnManager);
            this.clearCommandQueues();
        }
        catch (Throwable e) {
            if (txnManager != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit()) {
                try (DBCSession session = this.executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Rollback script transaction");){
                    session.enableLogging(false);
                    txnManager.rollback(session, null);
                }
                catch (DBCException e1) {
                    log.warn("Can't rollback transaction after error", e);
                }
            }
            throw e;
        }
        finally {
            if (txnManager != null && txnManager.isSupportsTransactions() && oldAutoCommit != useAutoCommit) {
                txnManager.setAutoCommit(monitor, oldAutoCommit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeCommands(DBRProgressMonitor monitor, Map<String, Object> options, DBCTransactionManager txnManager) throws DBException {
        List<CommandQueue> commandQueues = this.getCommandQueues();
        ArrayList<void> executedCommands = new ArrayList<void>();
        try {
            for (CommandQueue queue : commandQueues) {
                for (int i = 0; i < queue.commands.size() && !monitor.isCanceled(); ++i) {
                    void var9_11;
                    CommandInfo commandInfo = queue.commands.get(i);
                    while (var9_11.mergedBy != null) {
                        CommandInfo commandInfo2 = var9_11.mergedBy;
                    }
                    if (!var9_11.executed) {
                        Object[] persistActions = var9_11.command.getPersistActions(monitor, this.executionContext, options);
                        if (!ArrayUtils.isEmpty((Object[])persistActions)) {
                            var9_11.persistActions = new ArrayList<PersistInfo>(persistActions.length);
                            for (Object action : persistActions) {
                                var9_11.persistActions.add(new PersistInfo((DBEPersistAction)action));
                            }
                        }
                        if (!CommonUtils.isEmpty(var9_11.persistActions)) {
                            try (DBCSession session = this.openCommandPersistContext(monitor, var9_11.command);){
                                DBException error = null;
                                for (PersistInfo persistInfo : var9_11.persistActions) {
                                    DBEPersistAction.ActionType actionType = persistInfo.action.getType();
                                    if (actionType == DBEPersistAction.ActionType.COMMENT || persistInfo.executed && actionType == DBEPersistAction.ActionType.NORMAL) continue;
                                    if (monitor.isCanceled()) break;
                                    try {
                                        if (error == null || actionType == DBEPersistAction.ActionType.FINALIZER) {
                                            boolean disableSessionLogging;
                                            boolean bl = disableSessionLogging = session.isLoggingEnabled() && var9_11.command.isDisableSessionLogging();
                                            if (disableSessionLogging) {
                                                session.enableLogging(false);
                                            }
                                            queue.objectManager.executePersistAction(session, var9_11.command, persistInfo.action);
                                            if (disableSessionLogging) {
                                                session.enableLogging(true);
                                            }
                                        }
                                        persistInfo.executed = true;
                                    }
                                    catch (DBException e) {
                                        persistInfo.error = e;
                                        persistInfo.executed = false;
                                        if (actionType == DBEPersistAction.ActionType.OPTIONAL) continue;
                                        error = e;
                                    }
                                }
                                if (error != null) {
                                    throw error;
                                }
                                if (txnManager != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit()) {
                                    txnManager.commit(session);
                                }
                            }
                            var9_11.executed = true;
                        }
                    }
                    if (var9_11.executed) {
                        List<CommandInfo> list = this.commands;
                        synchronized (list) {
                            this.commands.remove(var9_11);
                        }
                    }
                    if (executedCommands.contains(var9_11)) continue;
                    executedCommands.add(var9_11);
                }
            }
            this.commands.clear();
            this.userParams.clear();
        }
        catch (Throwable throwable) {
            try {
                if (this.atomic) {
                    for (CommandInfo cmd : executedCommands) {
                        if (cmd.reflector == null) continue;
                        cmd.reflector.redoCommand(cmd.command);
                    }
                }
                for (CommandInfo cmd : executedCommands) {
                    cmd.command.updateModel();
                }
            }
            catch (Exception e) {
                log.warn("Error updating model", e);
            }
            this.clearCommandQueues();
            this.clearUndidCommands();
            DBECommandListener[] dBECommandListenerArray = this.getListeners();
            int n = dBECommandListenerArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    throw throwable;
                }
                DBECommandListener listener = dBECommandListenerArray[n2];
                listener.onSave();
                ++n2;
            }
        }
        try {
            if (this.atomic) {
                for (CommandInfo cmd : executedCommands) {
                    if (cmd.reflector == null) continue;
                    cmd.reflector.redoCommand(cmd.command);
                }
            }
            for (CommandInfo cmd : executedCommands) {
                cmd.command.updateModel();
            }
        }
        catch (Exception e) {
            log.warn("Error updating model", e);
        }
        this.clearCommandQueues();
        this.clearUndidCommands();
        Iterator<CommandQueue> iterator = this.getListeners();
        int n = ((Iterator<CommandQueue>)iterator).length;
        int n3 = 0;
        while (n3 < n) {
            Iterator<CommandQueue> iterator2 = iterator[n3];
            iterator2.onSave();
            ++n3;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetChanges(boolean undoCommands) {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            try {
                if (undoCommands) {
                    while (!this.commands.isEmpty()) {
                        this.undoCommand();
                    }
                }
                this.clearUndidCommands();
                this.clearCommandQueues();
                this.commands.clear();
                this.userParams.clear();
            }
            finally {
                for (DBECommandListener listener : this.getListeners()) {
                    listener.onReset();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<? extends DBECommand<?>> getFinalCommands() {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            ArrayList cmdCopy = new ArrayList(this.commands.size());
            for (CommandQueue queue : this.getCommandQueues()) {
                for (CommandInfo cmdInfo : queue.commands) {
                    while (cmdInfo.mergedBy != null) {
                        cmdInfo = cmdInfo.mergedBy;
                    }
                    if (cmdCopy.contains(cmdInfo.command)) continue;
                    cmdCopy.add(cmdInfo.command);
                }
            }
            return cmdCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<? extends DBECommand<?>> getUndoCommands() {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            ArrayList result = new ArrayList();
            for (int i = this.commands.size() - 1; i >= 0; --i) {
                CommandInfo cmd = this.commands.get(i);
                while (cmd.linkedCommand != null) {
                    cmd = cmd.linkedCommand;
                    --i;
                }
                if (!cmd.command.isUndoable()) break;
                result.add(cmd.command);
            }
            return result;
        }
    }

    @Override
    @NotNull
    public Collection<DBPObject> getEditedObjects() {
        List<CommandQueue> queues = this.getCommandQueues();
        ArrayList<DBPObject> result = new ArrayList<DBPObject>(queues.size());
        for (CommandQueue queue : queues) {
            result.add(queue.getObject());
        }
        return result;
    }

    @Override
    public void addCommand(@NotNull DBECommand<?> command, @Nullable DBECommandReflector reflector) {
        this.addCommand(command, reflector, false);
    }

    @Override
    public void addCommand(@NotNull DBECommand<?> command, @Nullable DBECommandReflector reflector, boolean execute) {
        this.addCommand(command, reflector, execute, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCommand(@NotNull DBECommand<?> command, @Nullable DBECommandReflector reflector, boolean execute, @Nullable DBECommand<?> linkedCommand) {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            CommandInfo newCommand = new CommandInfo(command, reflector);
            if (linkedCommand != null) {
                for (CommandInfo cmd : this.commands) {
                    if (cmd.command != linkedCommand) continue;
                    newCommand.linkedCommand = cmd;
                    break;
                }
            }
            this.commands.add(newCommand);
            this.clearUndidCommands();
            this.clearCommandQueues();
        }
        this.fireCommandChange(command);
        if (execute && reflector != null && !this.atomic) {
            reflector.redoCommand(command);
        }
        this.refreshCommandState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCommand(@NotNull DBECommand<?> command) {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            for (CommandInfo cmd : this.commands) {
                if (cmd.command != command) continue;
                this.commands.remove(cmd);
                break;
            }
            this.clearUndidCommands();
            this.clearCommandQueues();
        }
        this.fireCommandChange(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCommand(@NotNull DBECommand<?> command, @Nullable DBECommandReflector commandReflector) {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            boolean found = false;
            for (CommandInfo cmd : this.commands) {
                if (cmd.command != command) continue;
                found = true;
                break;
            }
            if (!found) {
                this.addCommand(command, commandReflector);
            } else {
                this.clearUndidCommands();
                this.clearCommandQueues();
            }
        }
        this.fireCommandChange(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCommandListener(@NotNull DBECommandListener listener) {
        List<DBECommandListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCommandListener(@NotNull DBECommandListener listener) {
        List<DBECommandListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public Map<Object, Object> getUserParams() {
        return this.userParams;
    }

    private void fireCommandChange(@NotNull DBECommand<?> command) {
        for (DBECommandListener listener : this.getListeners()) {
            listener.onCommandChange(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    DBECommandListener[] getListeners() {
        List<DBECommandListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(new DBECommandListener[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DBECommand<?> getUndoCommand() {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            if (!this.commands.isEmpty()) {
                CommandInfo cmd = this.commands.get(this.commands.size() - 1);
                while (cmd.linkedCommand != null) {
                    cmd = cmd.linkedCommand;
                }
                if (cmd.command.isUndoable()) {
                    return cmd.command;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DBECommand<?> getRedoCommand() {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            if (!this.undidCommands.isEmpty()) {
                CommandInfo cmd = this.undidCommands.getLast();
                while (cmd.linkedCommand != null) {
                    cmd = cmd.linkedCommand;
                }
                return cmd.command;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undoCommand() {
        if (this.getUndoCommand() == null) {
            throw new IllegalStateException("Can't undo command");
        }
        ArrayList<CommandInfo> processedCommands = new ArrayList<CommandInfo>();
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            CommandInfo lastCommand = this.commands.getLast();
            if (!lastCommand.command.isUndoable()) {
                throw new IllegalStateException("Last executed command is not undoable");
            }
            while (lastCommand != null) {
                this.commands.remove(lastCommand);
                this.undidCommands.add(lastCommand);
                processedCommands.add(lastCommand);
                lastCommand = lastCommand.linkedCommand;
            }
            this.clearCommandQueues();
            this.getCommandQueues();
        }
        this.refreshCommandState();
        for (CommandInfo cmd : processedCommands) {
            if (cmd.reflector == null || this.atomic) continue;
            cmd.reflector.undoCommand(cmd.command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redoCommand() {
        if (this.getRedoCommand() == null) {
            throw new IllegalStateException("Can't redo command");
        }
        ArrayList<CommandInfo> processedCommands = new ArrayList<CommandInfo>();
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            CommandInfo commandInfo = null;
            while (!(this.undidCommands.isEmpty() || commandInfo != null && this.undidCommands.getLast().linkedCommand != commandInfo)) {
                commandInfo = this.undidCommands.removeLast();
                this.commands.add(commandInfo);
                processedCommands.add(commandInfo);
            }
            this.clearCommandQueues();
            this.getCommandQueues();
        }
        for (CommandInfo cmd : processedCommands) {
            if (cmd.reflector == null) continue;
            cmd.reflector.redoCommand(cmd.command);
        }
        this.refreshCommandState();
    }

    private void clearUndidCommands() {
        this.undidCommands.clear();
    }

    private List<CommandQueue> getCommandQueues() {
        if (this.commandQueues != null) {
            return this.commandQueues;
        }
        this.commandQueues = new ArrayList<CommandQueue>();
        CommandInfo aggregator = null;
        for (CommandInfo commandInfo : this.commands) {
            if (commandInfo.command instanceof DBECommandAggregator && !commandInfo.command.ignoreNestedCommands()) {
                aggregator = commandInfo;
            }
            Object object = commandInfo.command.getObject();
            CommandQueue queue = null;
            if (!this.commandQueues.isEmpty()) {
                for (CommandQueue tmpQueue : this.commandQueues) {
                    if (tmpQueue.getObject() != object) continue;
                    queue = tmpQueue;
                    break;
                }
            }
            if (queue == null) {
                DBEObjectManager<?> objectManager = DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass());
                if (objectManager == null) {
                    throw new IllegalStateException("Can't find object manager for '" + object.getClass().getName() + "'");
                }
                queue = new CommandQueue(objectManager, null, (DBPObject)object);
                this.commandQueues.add(queue);
            }
            queue.addCommand(commandInfo);
        }
        for (CommandQueue queue : this.commandQueues) {
            IdentityHashMap mergedByMap = new IdentityHashMap();
            ArrayList<CommandInfo> mergedCommands = new ArrayList<CommandInfo>();
            for (int i = 0; i < queue.commands.size(); ++i) {
                int k;
                CommandInfo lastCommand = queue.commands.get(i);
                lastCommand.mergedBy = null;
                CommandInfo firstCommand = null;
                DBECommand<?> result = lastCommand.command;
                if (mergedCommands.isEmpty()) {
                    result = lastCommand.command.merge(null, this.userParams);
                } else {
                    boolean skipCommand = false;
                    for (k = mergedCommands.size(); k > 0; --k) {
                        firstCommand = (CommandInfo)mergedCommands.get(k - 1);
                        result = lastCommand.command.merge(firstCommand.command, this.userParams);
                        if (result == null) {
                            mergedCommands.remove(firstCommand);
                            skipCommand = true;
                            continue;
                        }
                        if (result != lastCommand.command) break;
                    }
                    if (skipCommand) continue;
                }
                mergedCommands.add(lastCommand);
                if (result == lastCommand.command) continue;
                if (firstCommand != null && result == firstCommand.command) {
                    lastCommand.mergedBy = firstCommand;
                    continue;
                }
                CommandInfo mergedBy = (CommandInfo)mergedByMap.get(result);
                if (mergedBy == null) {
                    for (k = i; k >= 0; --k) {
                        if (queue.commands.get((int)k).command != result) continue;
                        mergedBy = queue.commands.get(k);
                        break;
                    }
                    if (mergedBy == null) {
                        mergedBy = new CommandInfo(result, null);
                    }
                    mergedByMap.put(result, mergedBy);
                }
                lastCommand.mergedBy = mergedBy;
                if (mergedCommands.contains(mergedBy)) continue;
                mergedCommands.add(mergedBy);
            }
            queue.commands = mergedCommands;
        }
        for (CommandQueue queue : this.commandQueues) {
            if (!(queue.objectManager instanceof DBECommandFilter)) continue;
            ((DBECommandFilter)((Object)queue.objectManager)).filterCommands(queue);
        }
        if (aggregator != null) {
            ((DBECommandAggregator)aggregator.command).resetAggregatedCommands();
            for (CommandQueue queue : this.commandQueues) {
                for (CommandInfo cmd : queue.commands) {
                    if (cmd.command == aggregator.command || cmd.mergedBy != null || !((DBECommandAggregator)aggregator.command).aggregateCommand(cmd.command)) continue;
                    cmd.mergedBy = aggregator;
                }
            }
        }
        for (CommandQueue queue : this.commandQueues) {
            int headIndex = 0;
            for (CommandInfo cmd : new ArrayList<CommandInfo>(queue.commands)) {
                if (cmd.mergedBy != null || !(cmd.command instanceof DBECommandRename)) continue;
                queue.commands.remove(cmd);
                queue.commands.add(headIndex++, cmd);
            }
        }
        return this.commandQueues;
    }

    private void clearCommandQueues() {
        this.commandQueues = null;
    }

    protected DBCSession openCommandPersistContext(DBRProgressMonitor monitor, DBECommand<?> command) throws DBException {
        return this.executionContext.openSession(monitor, DBCExecutionPurpose.META_DDL, ModelMessages.model_edit_execute_ + command.getTitle());
    }

    protected void refreshCommandState() {
    }

    private static class CommandQueue
    extends AbstractCollection<DBECommand<DBPObject>>
    implements DBECommandQueue<DBPObject> {
        private final CommandQueue parent;
        private List<DBECommandQueue> subQueues;
        private final DBPObject object;
        private final DBEObjectManager objectManager;
        private List<CommandInfo> commands = new ArrayList<CommandInfo>();

        private CommandQueue(DBEObjectManager objectManager, CommandQueue parent, DBPObject object) {
            this.parent = parent;
            this.object = object;
            this.objectManager = objectManager;
            if (parent != null) {
                parent.addSubQueue(this);
            }
        }

        void addSubQueue(@NotNull CommandQueue queue) {
            if (this.subQueues == null) {
                this.subQueues = new ArrayList<DBECommandQueue>();
            }
            this.subQueues.add(queue);
        }

        void addCommand(@NotNull CommandInfo info) {
            this.commands.add(info);
        }

        @Override
        public DBPObject getObject() {
            return this.object;
        }

        @Override
        public DBECommandQueue getParentQueue() {
            return this.parent;
        }

        @Override
        public Collection<DBECommandQueue> getSubQueues() {
            return this.subQueues;
        }

        @Override
        public boolean add(@NotNull DBECommand dbeCommand) {
            return this.commands.add(new CommandInfo(dbeCommand, null));
        }

        @Override
        @NotNull
        public Iterator<DBECommand<DBPObject>> iterator() {
            return new Iterator<DBECommand<DBPObject>>(){
                private int index = -1;

                @Override
                public boolean hasNext() {
                    return this.index < commands.size() - 1;
                }

                @Override
                public DBECommand<DBPObject> next() {
                    ++this.index;
                    return commands.get((int)this.index).command;
                }

                @Override
                public void remove() {
                    commands.remove(this.index);
                }
            };
        }

        @Override
        public int size() {
            return this.commands.size();
        }
    }

    public static class CommandInfo {
        final DBECommand<?> command;
        final DBECommandReflector<?, DBECommand<?>> reflector;
        List<PersistInfo> persistActions;
        CommandInfo mergedBy = null;
        CommandInfo linkedCommand = null;
        boolean executed = false;

        CommandInfo(DBECommand<?> command, DBECommandReflector<?, DBECommand<?>> reflector) {
            this.command = command;
            this.reflector = reflector;
        }

        public String toString() {
            return this.command.toString() + " [executed=" + this.executed + ";merged by: " + String.valueOf(this.mergedBy) + "]";
        }
    }

    private static class PersistInfo {
        final DBEPersistAction action;
        boolean executed = false;
        Throwable error;

        public PersistInfo(DBEPersistAction action) {
            this.action = action;
        }
    }
}

