/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.expressions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentExpressionFunctions {
    private static final Log log = Log.getLog(ContentExpressionFunctions.class);
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).serializeNulls().setPrettyPrinting().create();

    public static Object json(Object object) {
        if (object == null) {
            return null;
        }
        return JSONUtils.parseMap(GSON, new StringReader(object.toString()));
    }

    public static Object xml(Object object, String expression) {
        return ContentExpressionFunctions.xml(object, "string", expression);
    }

    public static Object xml(Object object, String returnType, String expression) {
        if (object == null || CommonUtils.isEmpty((String)expression) || !(object instanceof DBDContent) || !((DBDContent)object).getContentType().equals("text/xml")) {
            return null;
        }
        XMLExpressionResultType resultType = XMLExpressionResultType.fromValue(returnType);
        if (resultType == null) {
            resultType = XMLExpressionResultType.STRING;
        }
        try {
            Object rawValue = ((DBDContent)object).getRawValue();
            String xmlValue = rawValue instanceof SQLXML ? ((SQLXML)rawValue).getString() : rawValue.toString();
            Document document = XMLUtils.parseDocument((Reader)new StringReader(xmlValue));
            XPath xPath = XPathFactory.newInstance().newXPath();
            Object result = xPath.evaluate(expression, document, resultType.getConstant());
            if (result instanceof NodeList) {
                ArrayList<String> valuesList = new ArrayList<String>();
                NodeList nodeList = (NodeList)result;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    valuesList.add(nodeList.item(i).getNodeValue());
                }
                return valuesList;
            }
            if (result instanceof Node) {
                return ((Node)result).getNodeValue();
            }
            return result;
        }
        catch (SQLException | XPathExpressionException | XMLException e) {
            log.error("Can't parse XML value", e);
            return null;
        }
    }

    private static enum XMLExpressionResultType {
        STRING("string", XPathConstants.STRING),
        NUMBER("number", XPathConstants.NUMBER),
        BOOLEAN("boolean", XPathConstants.BOOLEAN),
        NODE("node", XPathConstants.NODE),
        NODESET("nodeset", XPathConstants.NODESET);

        String name;
        QName constant;

        private XMLExpressionResultType(String name, QName constant) {
            this.name = name;
            this.constant = constant;
        }

        public QName getConstant() {
            return this.constant;
        }

        public static XMLExpressionResultType fromValue(String value) {
            for (XMLExpressionResultType type : XMLExpressionResultType.values()) {
                if (!type.name.equalsIgnoreCase(value)) continue;
                return type;
            }
            throw new IllegalArgumentException(value);
        }
    }
}

