/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.runtime.jobs.DataSourceUpdaterJob;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;

class EndIdleTransactionsJob
extends DataSourceUpdaterJob {
    private static final Log log = Log.getLog(EndIdleTransactionsJob.class);
    private static final Object CONFIRM_SYNC = new Object();
    private final DBPDataSource dataSource;
    private final Map<DBCExecutionContext, DBCTransactionManager> txnToEnd;

    EndIdleTransactionsJob(DBPDataSource dataSource, Map<DBCExecutionContext, DBCTransactionManager> txnToEnd) {
        super("End idle transaction for (" + dataSource.getContainer().getName() + ")");
        this.setUser(false);
        this.setSystem(true);
        this.dataSource = dataSource;
        this.txnToEnd = txnToEnd;
    }

    @Override
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IStatus updateDataSource(DBRProgressMonitor monitor) {
        UIServiceConnections serviceConnections = DBWorkbench.getService(UIServiceConnections.class);
        if (serviceConnections != null) {
            Iterator<Map.Entry<DBCExecutionContext, DBCTransactionManager>> iterator = CONFIRM_SYNC;
            synchronized (iterator) {
                if (!serviceConnections.confirmTransactionsClose(this.txnToEnd.keySet().toArray(new DBCExecutionContext[0]))) {
                    return Status.CANCEL_STATUS;
                }
            }
        }
        log.debug("End idle " + this.txnToEnd.size() + " transactions for " + this.dataSource.getContainer().getId());
        for (Map.Entry<DBCExecutionContext, DBCTransactionManager> tee : this.txnToEnd.entrySet()) {
            try {
                DBCSession session = tee.getKey().openSession(monitor, DBCExecutionPurpose.UTIL, "End idle transaction");
                try {
                    tee.getValue().rollback(session, null);
                }
                finally {
                    if (session == null) continue;
                    session.close();
                }
            }
            catch (DBException e) {
                log.error("Error ending idle transaction", e);
            }
        }
        DBeaverNotifications.showNotification(this.dataSource, "rollback.idle", "Transactions have been rolled back after long idle period (" + this.dataSource.getContainer().getName() + ")", DBPMessageType.ERROR);
        return Status.OK_STATUS;
    }
}

