/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.access.DBAAuthCredentialsWithComplexProperties;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceEditable;

public class PropertySerializationUtils {
    private static final Log log = Log.getLog(PropertySerializationUtils.class);
    public static String EMPTY_JSON_OBJECT = "{}";

    public static GsonBuilder baseNonSecurePropertiesGsonBuilder() {
        return new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new SecurePropertiesExclusionStrategy()}).setPrettyPrinting().setStrictness(Strictness.LENIENT);
    }

    public static GsonBuilder baseSecurePropertiesGsonBuilder() {
        return new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new NonSecurePropertiesExclusionStrategy()}).setPrettyPrinting().setStrictness(Strictness.LENIENT);
    }

    public static void updateCredentialsFromProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBAAuthCredentials credentials, @NotNull Map<String, ?> properties) {
        if (credentials instanceof DBAAuthCredentialsWithComplexProperties) {
            DBAAuthCredentialsWithComplexProperties complexProperties = (DBAAuthCredentialsWithComplexProperties)((Object)credentials);
            complexProperties.updateCredentialsFromComplexProperties(properties);
        }
        PropertySourceEditable editable = new PropertySourceEditable(credentials, credentials);
        editable.collectProperties();
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            String propId = entry.getKey();
            Object propValue = entry.getValue();
            DBPPropertyDescriptor propDesc = editable.getProperty(propId);
            if (propDesc == null) continue;
            try {
                editable.setPropertyValue(monitor, propId, propValue);
            }
            catch (Exception e) {
                log.error("Error setting credential property '" + propId + "'", e);
            }
        }
    }

    private static class SecurePropertiesExclusionStrategy
    implements ExclusionStrategy {
        private SecurePropertiesExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(SecureProperty.class) != null;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }

    private static class NonSecurePropertiesExclusionStrategy
    implements ExclusionStrategy {
        private NonSecurePropertiesExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(SecureProperty.class) == null;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }
}

