/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.connection.NewConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.ProjectSelectorPanel;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverSelectViewer;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverTreeViewer;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

class ConnectionPageDriver
extends ActiveWizardPage<NewConnectionWizard>
implements ISelectionChangedListener,
IDoubleClickListener {
    private DBPDriver selectedDriver;
    private DriverSelectViewer driverSelectViewer;
    private ProjectSelectorPanel projectSelector;
    private Control filterIndentLabel;

    ConnectionPageDriver(NewConnectionWizard wizard) {
        super("newConnectionDrivers");
        this.setTitle(CoreMessages.dialog_new_connection_wizard_start_title);
        this.setDescription(CoreMessages.dialog_new_connection_wizard_start_description);
    }

    public void createControl(Composite parent) {
        Composite placeholder = UIUtils.createComposite((Composite)parent, (int)1);
        this.setControl((Control)placeholder);
        Composite controlsGroup = UIUtils.createComposite((Composite)placeholder, (int)4);
        controlsGroup.setLayoutData((Object)new GridData(768));
        this.driverSelectViewer = new DriverSelectViewer(placeholder, (Object)this, ((NewConnectionWizard)this.getWizard()).getAvailableProvides(), true, DriverSelectViewer.SelectorViewType.browser){

            protected void createExtraFilterControlsBefore(Composite filterGroup) {
                ++((GridLayout)filterGroup.getLayout()).numColumns;
                ConnectionPageDriver.this.filterIndentLabel = UIUtils.createEmptyLabel((Composite)filterGroup, (int)1, (int)1);
                GridData gd = new GridData();
                gd.widthHint = 100;
                ConnectionPageDriver.this.filterIndentLabel.setLayoutData((Object)gd);
            }

            protected void createExtraFilterControlsAfter(Composite filterGroup) {
                ++((GridLayout)filterGroup.getLayout()).numColumns;
                Composite extraControlsComposite = UIUtils.createComposite((Composite)filterGroup, (int)1);
                extraControlsComposite.setLayoutData((Object)new GridData(128));
                ConnectionPageDriver.this.createSorterControl(extraControlsComposite);
            }
        };
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 400;
        this.driverSelectViewer.getControl().setLayoutData((Object)gd);
        ((GridData)this.filterIndentLabel.getLayoutData()).widthHint = this.driverSelectViewer.getTabbedViewer().getFolderComposite().getTabsWidth() - ((GridLayout)this.filterIndentLabel.getParent().getLayout()).horizontalSpacing - 1;
        Composite bottomPanel = new Composite(placeholder, 0);
        bottomPanel.setLayout((Layout)new GridLayout(2, false));
        GridData gd2 = new GridData(768);
        bottomPanel.setLayoutData((Object)gd2);
        UIUtils.createEmptyLabel((Composite)bottomPanel, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        this.projectSelector = new ProjectSelectorPanel(bottomPanel, NavigatorUtils.getSelectedProject(), 0, true);
        if (this.projectSelector.getSelectedProject() == null) {
            this.setErrorMessage("You need to create a project first");
        }
        Dialog.applyDialogFont((Control)placeholder);
        UIUtils.setHelp((Control)placeholder, (String)"con-wizard-driver");
        UIUtils.asyncExec(() -> this.driverSelectViewer.getControl().setFocus());
    }

    public void createSorterControl(Composite controlsGroup) {
        Composite orderGroup = new Composite(controlsGroup, 0);
        orderGroup.setLayoutData((Object)new GridData(128));
        orderGroup.setLayout((Layout)new RowLayout());
        new Label(orderGroup, 0).setText(CoreMessages.driver_connection_sort_by + " ");
        DriverSelectViewer.OrderBy defaultOrderBy = DriverSelectViewer.getDefaultOrderBy();
        for (DriverSelectViewer.OrderBy ob : DriverSelectViewer.OrderBy.values()) {
            final Button obScoreButton = new Button(orderGroup, 16);
            obScoreButton.setText(ob.getLabel());
            obScoreButton.setToolTipText(ob.getDescription());
            obScoreButton.setData((Object)ob);
            if (ob == defaultOrderBy) {
                obScoreButton.setSelection(true);
            }
            obScoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ConnectionPageDriver this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$0.driverSelectViewer.setOrderBy((DriverSelectViewer.OrderBy)obScoreButton.getData());
                }
            });
        }
    }

    public DBPDriver getSelectedDriver() {
        return this.selectedDriver;
    }

    public void setSelectedDriver(DBPDriver selectedDriver) {
        this.selectedDriver = selectedDriver;
    }

    public DBPProject getConnectionProject() {
        return this.projectSelector.getSelectedProject();
    }

    public DBNBrowseSettings getNavigatorSettings() {
        return DataSourceNavigatorSettings.getDefaultSettings();
    }

    public boolean canFlipToNextPage() {
        return this.projectSelector.getSelectedProject() != null && this.selectedDriver != null;
    }

    public boolean isPageComplete() {
        if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("database-developer")) {
            this.setErrorMessage("The user needs more permissions to create a new connection.");
            return false;
        }
        return this.canFlipToNextPage();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectedDriver = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object selectedObject = ss.getFirstElement();
            if (selectedObject instanceof DriverDescriptor) {
                DriverDescriptor driver = (DriverDescriptor)selectedObject;
                this.selectedDriver = driver;
            } else if (selectedObject instanceof DataSourceProviderDescriptor || selectedObject instanceof DriverTreeViewer.DriverCategory) {
                // empty if block
            }
        }
        ((NewConnectionWizard)this.getWizard()).getContainer().updateButtons();
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.selectedDriver != null && this.projectSelector.getSelectedProject() != null) {
            NewConnectionWizard wizard = (NewConnectionWizard)this.getWizard();
            wizard.getContainer().showPage(wizard.getNextPage((IWizardPage)this));
        }
    }
}

