/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdDataSource;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdDataType;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdFieldType;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class FireBirdDataTypeCache
extends JDBCBasicDataTypeCache<GenericStructContainer, FireBirdDataType> {
    private static final Log log = Log.getLog(FireBirdDataTypeCache.class);

    public FireBirdDataTypeCache(GenericStructContainer owner) {
        super((DBSObject)owner);
    }

    protected synchronized void loadObjects(DBRProgressMonitor monitor, GenericStructContainer container) throws DBException {
        ArrayList<FireBirdDataType> tmpObjectList;
        block27: {
            FireBirdDataSource dataSource = (FireBirdDataSource)container.getDataSource();
            if (dataSource == null) {
                throw new DBException(ModelMessages.error_not_connected_to_database);
            }
            tmpObjectList = new ArrayList<FireBirdDataType>();
            for (FireBirdFieldType fieldType : FireBirdFieldType.values()) {
                FireBirdDataType dataType = new FireBirdDataType(dataSource, fieldType);
                tmpObjectList.add(dataType);
            }
            try {
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)"Load Firebird domain types");
                     JDBCPreparedStatement dbStat = session.prepareStatement("SELECT RDB$FIELD_NAME,RDB$FIELD_LENGTH,RDB$FIELD_SCALE,RDB$FIELD_PRECISION,RDB$FIELD_TYPE,RDB$FIELD_SUB_TYPE,RDB$CHARACTER_LENGTH,RDB$CHARACTER_SET_ID,\nCAST(RDB$VALIDATION_SOURCE AS VARCHAR(512)) VALIDATION_SOURCE,SUBSTRING(RDB$COMPUTED_SOURCE FROM 1 FOR 512) COMPUTED_SOURCE,CAST(RDB$DEFAULT_SOURCE AS VARCHAR(512)) DEFAULT_SOURCE\nFROM RDB$FIELDS F ORDER BY RDB$FIELD_NAME");){
                    monitor.subTask("Load Firebird domain types");
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            if (monitor.isCanceled()) {
                                break;
                            }
                            String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RDB$FIELD_NAME");
                            if (typeName == null) continue;
                            int fieldLength = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$FIELD_LENGTH");
                            int fieldScale = Math.abs(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$FIELD_SCALE"));
                            int fieldPrecision = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$FIELD_PRECISION");
                            int fieldType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$FIELD_TYPE");
                            int fieldSubType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$FIELD_SUB_TYPE");
                            int charLength = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$CHARACTER_LENGTH");
                            int charsetId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$CHARACTER_SET_ID");
                            String validationSource = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VALIDATION_SOURCE");
                            String computedSource = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMPUTED_SOURCE");
                            String typeDescription = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RDB$DESCRIPTION");
                            String defaultSource = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEFAULT_SOURCE");
                            FireBirdFieldType fieldDT = FireBirdFieldType.getById(fieldType, fieldSubType);
                            if (fieldDT == null) {
                                log.error((Object)("Field type '" + fieldType + "' not found"));
                                continue;
                            }
                            String charsetName = dataSource.getMetaFieldValue("RDB$CHARACTER_SET_NAME", charsetId);
                            boolean notNull = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$NULL_FLAG") == 1;
                            FireBirdDataType dataType = new FireBirdDataType(dataSource, fieldDT, fieldSubType, typeName.trim(), typeDescription, false, true, fieldPrecision, fieldScale, fieldScale, fieldLength, charLength, computedSource, validationSource, defaultSource, charsetName, notNull);
                            tmpObjectList.add(dataType);
                        }
                    }
                }
                catch (SQLException ex) {
                    throw new DBDatabaseException((Throwable)ex, (DBPDataSource)dataSource);
                }
            }
            catch (DBException e) {
                if (this.handleCacheReadError((Exception)((Object)e))) break block27;
                throw e;
            }
        }
        this.mergeCache(tmpObjectList);
    }
}

