/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.plan;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanNode;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanStatement;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;

public class DB2PlanAnalyser
extends AbstractExecutionPlan {
    private static final Log LOG = Log.getLog(DB2PlanAnalyser.class);
    private static String PT_DELETE;
    private static final String PT_EXPLAIN = "EXPLAIN PLAN SET QUERYNO = %d FOR %s";
    private static final String SEL_STMT = "SELECT * FROM %s.EXPLAIN_STATEMENT WHERE QUERYNO = ? AND EXPLAIN_LEVEL = 'P' WITH UR";
    private static AtomicInteger STMT_NO_GEN;
    private String query;
    private String planTableSchema;
    private List<DB2PlanNode> listNodes;
    private DB2PlanStatement db2PlanStatement;

    public DB2PlanAnalyser(String query, String planTableSchema) {
        this.query = query;
        this.planTableSchema = planTableSchema;
    }

    public Object getPlanFeature(String feature) {
        if ("plan.cost".equals(feature) || "plan.duration".equals(feature) || "plan.rows".equals(feature)) {
            return true;
        }
        if ("plan.duration.measure".equals(feature)) {
            return "ms";
        }
        return super.getPlanFeature(feature);
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        return String.format(PT_EXPLAIN, STMT_NO_GEN.get(), this.query);
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.listNodes;
    }

    public void explain(JDBCSession session) throws DBCException {
        Integer stmtNo = STMT_NO_GEN.incrementAndGet();
        String explainStmt = String.format(PT_EXPLAIN, stmtNo, this.query);
        LOG.debug((Object)("Schema=" + this.planTableSchema + " : " + explainStmt));
        try {
            this.cleanExplainTables(session, stmtNo, this.planTableSchema);
            try (JDBCPreparedStatement dbStat = session.prepareStatement(explainStmt);){
                dbStat.execute();
            }
            dbStat = session.prepareStatement(String.format(SEL_STMT, this.planTableSchema));
            try {
                dbStat.setInt(1, stmtNo.intValue());
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    dbResult.next();
                    this.db2PlanStatement = new DB2PlanStatement(session, dbResult, this.planTableSchema);
                }
            }
            finally {
                if (dbStat != null) {
                    dbStat.close();
                }
            }
            this.listNodes = this.db2PlanStatement.buildNodes();
            this.cleanExplainTables(session, stmtNo, this.planTableSchema);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
    }

    private void cleanExplainTables(JDBCSession session, Integer stmtNo, String planTableSchema) throws SQLException {
        try (JDBCPreparedStatement dbStat = session.prepareStatement(String.format(PT_DELETE, planTableSchema, planTableSchema));){
            dbStat.setInt(1, stmtNo.intValue());
            dbStat.execute();
        }
    }

    static {
        STMT_NO_GEN = new AtomicInteger(Long.valueOf(System.currentTimeMillis() / 10000000L).intValue());
        StringBuilder sb = new StringBuilder(256);
        sb.append("DELETE");
        sb.append("  FROM %s.EXPLAIN_INSTANCE I");
        sb.append(" WHERE EXISTS (SELECT 1");
        sb.append("                 FROM %s.EXPLAIN_STATEMENT S");
        sb.append("                WHERE S.EXPLAIN_TIME = I.EXPLAIN_TIME");
        sb.append("                  AND S.SOURCE_NAME = I.SOURCE_NAME");
        sb.append("                  AND S.SOURCE_SCHEMA = I.SOURCE_SCHEMA");
        sb.append("                  AND S.SOURCE_VERSION = I.SOURCE_VERSION");
        sb.append("                  AND QUERYNO = ?)");
        PT_DELETE = sb.toString();
    }
}

