/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.ui.config;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolGrantee;
import org.jkiss.dbeaver.ext.exasol.ui.internal.ExasolMessages;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ExasolCreateSchemaDialog
extends BaseDialog {
    private List<ExasolGrantee> grantees;
    private String name;
    private ExasolDataSource datasource;
    private ExasolGrantee owner;

    public ExasolCreateSchemaDialog(Shell parentShell, ExasolDataSource datasource) {
        super(parentShell, ExasolMessages.dialog_create_schema_title, null);
        this.datasource = datasource;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite group = new Composite(composite, 0);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout(2, false));
        Text nameText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_create_schema_schema_name, (String)"");
        nameText.addModifyListener(e -> {
            this.name = nameText.getText().trim();
            this.updateButtons();
        });
        final Combo userCombo = UIUtils.createLabelCombo((Composite)group, (String)ExasolMessages.dialog_create_schema_owner, (int)2060);
        userCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ ExasolCreateSchemaDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                this.this$0.owner = this.this$0.grantees.get(userCombo.getSelectionIndex());
            }
        });
        new AbstractJob(this, "Load users"){
            final /* synthetic */ ExasolCreateSchemaDialog this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                try {
                    this.this$0.grantees = new ArrayList<ExasolGrantee>(this.this$0.datasource.getAllGrantees(monitor));
                    UIUtils.syncExec(() -> {
                        for (ExasolGrantee grantee : this.this$0.grantees) {
                            String name = grantee.getName();
                            userCombo.add(name);
                        }
                    });
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return composite;
    }

    private void updateButtons() {
        this.getButton(0).setEnabled(!this.name.isEmpty());
    }

    public String getName() {
        return this.name;
    }

    public ExasolGrantee getOwner() {
        return this.owner;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

