/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.sql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.registry.task.TaskTypeDescriptor;
import org.jkiss.dbeaver.tasks.ui.sql.internal.TasksSQLUIMessages;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;

class SQLToolTaskObjectSelectorDialog
extends BaseDialog {
    private DBNProject projectNode;
    private TaskTypeDescriptor taskType;
    private DatabaseNavigatorTree dataSourceTree;
    private List<DBSObject> selectedObjects = new ArrayList<DBSObject>();
    private static boolean showConnected;

    SQLToolTaskObjectSelectorDialog(Shell parentShell, DBNProject projectNode, TaskTypeDescriptor taskType) {
        super(parentShell, TasksSQLUIMessages.sql_tool_task_object_selector_dialog_title, null);
        this.projectNode = projectNode;
        this.taskType = taskType;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        DatabaseNavigatorTreeFilter dsFilter = new DatabaseNavigatorTreeFilter(){

            public boolean filterFolders() {
                return true;
            }

            public boolean isLeafObject(Object object) {
                return object instanceof DBNDatabaseItem && SQLToolTaskObjectSelectorDialog.this.taskType.appliesTo((DBPObject)((DBNDatabaseItem)object).getObject());
            }

            public boolean select(Object element) {
                if (element instanceof DBNProject || element instanceof DBNProjectDatabases) {
                    return true;
                }
                if (element instanceof DBNLocalFolder) {
                    for (DBNDataSource ds : ((DBNLocalFolder)element).getNestedDataSources()) {
                        if (!SQLToolTaskObjectSelectorDialog.this.taskType.isDriverApplicable(ds.getDataSourceContainer().getDriver()) || showConnected && !ds.getDataSourceContainer().isConnected()) continue;
                        return true;
                    }
                    return false;
                }
                if (element instanceof DBNDataSource) {
                    if (showConnected && !((DBNDataSource)element).getDataSourceContainer().isConnected()) {
                        return false;
                    }
                    return SQLToolTaskObjectSelectorDialog.this.taskType.isDriverApplicable(((DBNDataSource)element).getDataSourceContainer().getDriver());
                }
                if (element instanceof DBNDatabaseItem) {
                    DBSObject object = ((DBNDatabaseItem)element).getObject();
                    return DBSObjectContainer.class.isAssignableFrom(object.getClass()) || SQLToolTaskObjectSelectorDialog.this.taskType.matchesEntityElements() && DBSEntity.class.isAssignableFrom(object.getClass()) || SQLToolTaskObjectSelectorDialog.this.taskType.appliesTo((DBPObject)object);
                }
                if (element instanceof DBNDatabaseFolder) {
                    Class childrenClass = ((DBNDatabaseFolder)element).getChildrenClass();
                    return childrenClass != null && (DBSObjectContainer.class.isAssignableFrom(childrenClass) || SQLToolTaskObjectSelectorDialog.this.taskType.matchesEntityElements() && DBSEntity.class.isAssignableFrom(childrenClass) || SQLToolTaskObjectSelectorDialog.this.taskType.matchesType(childrenClass));
                }
                return element instanceof TreeNodeSpecial;
            }
        };
        this.dataSourceTree = new DatabaseNavigatorTree(dialogArea, (DBNNode)this.projectNode.getDatabases(), 2084, false, (INavigatorFilter)dsFilter);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 400;
        this.dataSourceTree.setLayoutData((Object)gd);
        this.dataSourceTree.getViewer().addSelectionChangedListener(event -> this.updateSelectedObjects());
        final Button showConnectedCheck = new Button(dialogArea, 32);
        showConnectedCheck.setText(UINavigatorMessages.label_show_connected);
        showConnectedCheck.setSelection(showConnected);
        showConnectedCheck.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ SQLToolTaskObjectSelectorDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                showConnected = showConnectedCheck.getSelection();
                this.this$0.dataSourceTree.getViewer().refresh();
            }
        });
        return dialogArea;
    }

    private void updateSelectedObjects() {
        this.selectedObjects.clear();
        for (Object element : this.dataSourceTree.getCheckboxViewer().getCheckedElements()) {
            if (!(element instanceof DBNDatabaseItem) || !this.taskType.matchesType(((DBNDatabaseItem)element).getObject().getClass())) continue;
            this.selectedObjects.add(((DBNDatabaseItem)element).getObject());
        }
        this.getButton(0).setEnabled(!this.selectedObjects.isEmpty());
    }

    public List<DBSObject> getSelectedObjects() {
        return this.selectedObjects;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

