/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.kingbase.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.kingbase.model.KingbaseDataSource;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCharset;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class KingbaseCreateDatabaseDialog
extends BaseDialog {
    private final KingbaseDataSource dataSource;
    private List<PostgreRole> allUsers;
    private List<PostgreCharset> allEncodings;
    private List<PostgreTablespace> allTablespaces;
    private String name;
    private PostgreRole owner;
    private String dbTemplate;
    private PostgreCharset encoding;
    private PostgreTablespace tablespace;
    private String compatibleMode;
    private Combo dbCompatibleMode;
    private Combo userCombo;
    private Combo encodingCombo;
    private Combo tablespaceCombo;

    public KingbaseCreateDatabaseDialog(Shell parentShell, KingbaseDataSource dataSource) {
        super(parentShell, PostgreMessages.dialog_create_db_title, null);
        this.dataSource = dataSource;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite groupGeneral = UIUtils.createTitledComposite((Composite)composite, (String)PostgreMessages.dialog_create_db_group_general, (int)2, (int)768);
        Text nameText = UIUtils.createLabelText((Composite)groupGeneral, (String)PostgreMessages.dialog_create_db_label_db_name, (String)"");
        nameText.addModifyListener(e -> {
            this.name = nameText.getText().trim();
            this.enableButton(0, !this.name.isEmpty());
        });
        Composite groupDefinition = UIUtils.createTitledComposite((Composite)composite, (String)PostgreMessages.dialog_create_db_group_definition, (int)2, (int)768);
        boolean supportsRoles = true;
        boolean supportsEncodings = this.dataSource.getServerType().supportsEncodings();
        boolean supportsTablespaces = this.dataSource.getServerType().supportsTablespaces();
        this.supportsRoles(supportsRoles, groupGeneral);
        this.supportsEncodings(supportsEncodings, groupDefinition);
        this.supportsTablespaces(supportsTablespaces, groupDefinition);
        this.dbCompatibleMode = UIUtils.createLabelCombo((Composite)groupDefinition, (String)"DataBase Compatibility Mode", (int)2060);
        this.dbCompatibleMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KingbaseCreateDatabaseDialog.this.compatibleMode = KingbaseCreateDatabaseDialog.this.dbCompatibleMode.getText();
            }
        });
        this.scheduleLoadUsersJob(supportsRoles, supportsEncodings, supportsTablespaces);
        return composite;
    }

    private void scheduleLoadUsersJob(final boolean supportsRoles, final boolean supportsEncodings, final boolean supportsTablespaces) {
        new AbstractJob(this, "Load users"){
            final /* synthetic */ KingbaseCreateDatabaseDialog this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                monitor.beginTask("Create database", 1);
                try {
                    PostgreDatabase database = this.this$0.dataSource.getDefaultInstance();
                    this.this$0.allUsers = supportsRoles ? new ArrayList(database.getUsers(monitor)) : null;
                    this.this$0.allEncodings = supportsEncodings ? new ArrayList(database.getEncodings(monitor)) : null;
                    this.this$0.allTablespaces = supportsTablespaces ? new ArrayList(database.getTablespaces(monitor)) : null;
                    PostgreRole dba = supportsRoles ? database.getDBA(monitor) : null;
                    String defUserName = dba == null ? "" : dba.getName();
                    PostgreCharset defCharset = supportsEncodings ? database.getDefaultEncoding(monitor) : null;
                    PostgreTablespace defTablespace = supportsTablespaces ? database.getDefaultTablespace(monitor) : null;
                    UIUtils.syncExec(() -> this.this$0.populateDialog(defUserName, defCharset, defTablespace));
                }
                catch (DBException e) {
                    IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void populateDialog(String defUserName, PostgreCharset defCharset, PostgreTablespace defTablespace) {
        if (this.userCombo != null) {
            for (PostgreRole authId : this.allUsers) {
                String name = authId.getName();
                this.userCombo.add(name);
                if (!name.equals(defUserName)) continue;
                this.owner = authId;
            }
            this.userCombo.setText(defUserName);
        }
        if (this.encodingCombo != null) {
            for (PostgreCharset charset : this.allEncodings) {
                this.encodingCombo.add(charset.getName());
                if (charset != defCharset) continue;
                this.encoding = defCharset;
            }
            if (defCharset != null) {
                this.encodingCombo.setText(defCharset.getName());
            }
        }
        if (this.tablespaceCombo != null) {
            this.tablespaceCombo.add(PostgreMessages.dialog_create_db_tablespace_default);
            for (PostgreTablespace ts : this.allTablespaces) {
                this.tablespaceCombo.add(ts.getName());
                if (ts != defTablespace) continue;
                this.tablespace = defTablespace;
            }
            if (defTablespace != null) {
                this.tablespaceCombo.setText(defTablespace.getName());
            }
        }
    }

    private void supportsTablespaces(boolean supportsTablespaces, Composite groupDefinition) {
        if (supportsTablespaces) {
            this.tablespaceCombo = UIUtils.createLabelCombo((Composite)groupDefinition, (String)PostgreMessages.dialog_create_db_label_tablesapce, (int)2060);
            this.tablespaceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KingbaseCreateDatabaseDialog.this.tablespace = KingbaseCreateDatabaseDialog.this.tablespaceCombo.getSelectionIndex() == 0 ? null : KingbaseCreateDatabaseDialog.this.allTablespaces.get(KingbaseCreateDatabaseDialog.this.tablespaceCombo.getSelectionIndex() - 1);
                }
            });
        }
    }

    private void supportsEncodings(boolean supportsEncodings, Composite groupDefinition) {
        if (supportsEncodings) {
            this.encodingCombo = UIUtils.createLabelCombo((Composite)groupDefinition, (String)PostgreMessages.dialog_create_db_label_encoding, (int)2060);
            this.encodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KingbaseCreateDatabaseDialog.this.encoding = KingbaseCreateDatabaseDialog.this.allEncodings.get(KingbaseCreateDatabaseDialog.this.encodingCombo.getSelectionIndex());
                }
            });
        }
    }

    private void supportsRoles(boolean supportsRoles, Composite groupGeneral) {
        if (supportsRoles) {
            this.userCombo = UIUtils.createLabelCombo((Composite)groupGeneral, (String)PostgreMessages.dialog_create_db_label_owner, (int)2060);
            this.userCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KingbaseCreateDatabaseDialog.this.owner = KingbaseCreateDatabaseDialog.this.allUsers.get(KingbaseCreateDatabaseDialog.this.userCombo.getSelectionIndex());
                }
            });
        }
    }

    public String getCompatibleMode() {
        return this.compatibleMode;
    }

    public String getName() {
        return this.name;
    }

    public PostgreRole getOwner() {
        return this.owner;
    }

    public String getTemplateName() {
        return this.dbTemplate;
    }

    public PostgreCharset getEncoding() {
        return this.encoding;
    }

    public PostgreTablespace getTablespace() {
        return this.tablespace;
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.enableButton(0, false);
    }
}

