/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.access.DBAAuthCredentialsForm;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.registry.DataSourceBindingDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverLibraryAbstract;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataSourceAuthModelDescriptor
extends DataSourceBindingDescriptor
implements DBPAuthModelDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataSourceAuth";
    private final String id;
    private final AbstractDescriptor.ObjectType implType;
    private final String name;
    private final String description;
    private final String requiredAuthProvider;
    private DBPImage icon;
    private final boolean defaultModel;
    private final boolean isDesktop;
    private final boolean isCloud;
    private final boolean requiresLocalConfiguration;
    private final Map<String, String[]> replaces = new HashMap<String, String[]>();
    private final List<DBPDriverLibrary> libraries;
    private boolean hasCondReplaces = false;
    private DBAAuthModel<?> instance;

    DataSourceAuthModelDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        if (this.icon == null) {
            this.icon = DBIcon.TREE_PACKAGE;
        }
        this.defaultModel = CommonUtils.toBoolean((Object)config.getAttribute("default"));
        this.isDesktop = CommonUtils.toBoolean((Object)config.getAttribute("desktop"));
        this.isCloud = CommonUtils.toBoolean((Object)config.getAttribute("cloud"));
        this.requiresLocalConfiguration = CommonUtils.toBoolean((Object)config.getAttribute("requiresLocalConfiguration"));
        this.requiredAuthProvider = CommonUtils.toString((Object)config.getAttribute("requiredAuthProvider"));
        for (IConfigurationElement dsConfig : config.getChildren("replace")) {
            String replModel = dsConfig.getAttribute("model");
            String forAttr = dsConfig.getAttribute("for");
            Object[] replFor = CommonUtils.isEmpty((String)forAttr) ? new String[]{} : forAttr.split(",");
            this.replaces.put(replModel, (String[])replFor);
            this.hasCondReplaces = this.hasCondReplaces || !ArrayUtils.isEmpty((Object[])replFor);
        }
        this.libraries = new ArrayList<DBPDriverLibrary>();
        for (IConfigurationElement libConfig : config.getChildren("file")) {
            DriverLibraryAbstract lib = DriverLibraryAbstract.createFromConfig(null, libConfig);
            if (lib == null) continue;
            lib.setCustom(false);
            this.libraries.add(lib);
        }
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    @NotNull
    public String getImplClassName() {
        return this.implType.getImplName();
    }

    public boolean isDefaultModel() {
        return this.defaultModel;
    }

    public boolean isDesktopModel() {
        return this.isDesktop;
    }

    public boolean isCloudModel() {
        return this.isCloud;
    }

    public boolean requiresLocalConfiguration() {
        return this.requiresLocalConfiguration;
    }

    public boolean isApplicableTo(DBPDriver driver) {
        return this.appliesTo(driver);
    }

    @Nullable
    public DBPAuthModelDescriptor getReplacedBy(@NotNull DBPDriver driver) {
        List<? extends DBPAuthModelDescriptor> applicableAMs = DataSourceProviderRegistry.getInstance().getApplicableAuthModels(driver);
        List<DataSourceAuthModelDescriptor> allAuthModels = DataSourceProviderRegistry.getInstance().getAllAuthModels();
        for (int i = allAuthModels.size(); i > 0; --i) {
            DataSourceAuthModelDescriptor amd = allAuthModels.get(i - 1);
            if (!applicableAMs.contains((Object)amd) || !amd.getReplaces(driver).contains(this.id) || !amd.isDriverApplicable(driver)) continue;
            return amd;
        }
        return null;
    }

    @NotNull
    public <T extends DBAAuthCredentials> DBAAuthModel<T> getInstance() {
        if (this.instance == null) {
            try {
                this.instance = (DBAAuthModel)this.implType.createInstance(DBAAuthModel.class);
            }
            catch (Throwable ex) {
                this.instance = null;
                throw new IllegalStateException("Can't initialize data source auth model '" + this.implType.getImplName() + "'", ex);
            }
        }
        return this.instance;
    }

    @NotNull
    public DBPPropertySource createCredentialsSource(DBPDataSourceContainer dataSource, DBPConnectionConfiguration configuration) {
        DBAAuthModel instance = this.getInstance();
        DBAAuthCredentialsForm credentialsForm = instance.createCredentialsForm(dataSource, configuration);
        PropertyCollector propertyCollector = new PropertyCollector((Object)credentialsForm, false);
        propertyCollector.collectProperties();
        return propertyCollector;
    }

    @Nullable
    public String getRequiredAuthProviderId() {
        return this.requiredAuthProvider;
    }

    boolean appliesTo(DBPDriver driver) {
        return this.isDriverApplicable(driver);
    }

    public Collection<String> getReplaces(DBPDriver driver) {
        if (this.hasCondReplaces) {
            ArrayList<String> replList = new ArrayList<String>();
            for (Map.Entry<String, String[]> re : this.replaces.entrySet()) {
                Object[] forList = re.getValue();
                if (!ArrayUtils.isEmpty((Object[])forList) && !ArrayUtils.contains((Object[])forList, (Object)driver.getId()) && !ArrayUtils.contains((Object[])forList, (Object)driver.getProviderId())) continue;
                replList.add(re.getKey());
            }
            return replList;
        }
        return this.replaces.keySet();
    }

    @NotNull
    public List<? extends DBPDriverLibrary> getDriverLibraries() {
        return this.libraries;
    }

    public String toString() {
        return this.id;
    }
}

