/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.ExasolSysTablePrefix;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class ExasolCurrentUserPrivileges {
    private static final Log LOG = Log.getLog(ExasolCurrentUserPrivileges.class);
    private static final String C_QUERY_DICTIONARY = "/*snapshot execution*/ SELECT CONNECTION_NAME FROM sys.EXA_DBA_CONNECTIONS WHERE false";
    private static final String C_MAJOR_VERSION = "/*snapshot execution*/ select TO_NUMBER(\"VALUE\") AS VERSION from \"$ODBCJDBC\".DB_METADATA WHERE name LIKE 'databaseMajorVersion'";
    private static final String C_MINOR_VERSION = "/*snapshot execution*/ select TO_NUMBER(\"VALUE\") AS VERSION from \"$ODBCJDBC\".DB_METADATA WHERE name LIKE 'databaseMinorVersion'";
    private final Boolean userHasDictionaryAccess;
    private final Integer majorVersion;
    private final Integer minorVersion;

    public ExasolCurrentUserPrivileges(DBRProgressMonitor monitor, JDBCSession session, ExasolDataSource exasolDataSource) {
        this.userHasDictionaryAccess = ExasolCurrentUserPrivileges.verifyPriv(C_QUERY_DICTIONARY, session);
        this.majorVersion = ExasolCurrentUserPrivileges.queryVersion(C_MAJOR_VERSION, session);
        this.minorVersion = ExasolCurrentUserPrivileges.queryVersion(C_MINOR_VERSION, session);
    }

    public int getExasolVersion() {
        return this.majorVersion;
    }

    public Boolean getAtLeastV5() {
        return this.majorVersion >= 5;
    }

    public Boolean getAtLeastV6() {
        return this.majorVersion >= 6;
    }

    public Boolean getAtLeastV8() {
        return this.majorVersion >= 8;
    }

    public Boolean getUserHasDictionaryAccess() {
        return this.userHasDictionaryAccess;
    }

    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    public String getTablePrefix(ExasolSysTablePrefix fallback) {
        if (this.userHasDictionaryAccess.booleanValue()) {
            return ExasolSysTablePrefix.DBA.toString();
        }
        return fallback.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Integer queryVersion(String sql, JDBCSession session) {
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            Integer n;
            block14: {
                JDBCResultSet rs = dbStat.executeQuery();
                try {
                    Integer version;
                    rs.next();
                    n = version = Integer.valueOf(JDBCUtils.safeGetInt((ResultSet)rs, (String)"VERSION"));
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return n;
        }
        catch (SQLException e) {
            LOG.error((Object)"Error extracting Exasol version: fallback to version 5");
            Integer version = 5;
            return version;
        }
    }

    private static Boolean verifyPriv(String sql, JDBCSession session) {
        Boolean hasPriv;
        try {
            try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                JDBCResultSet rs = dbStat.executeQuery();
                if (rs != null) {
                    rs.close();
                }
            }
            hasPriv = true;
        }
        catch (Exception e) {
            hasPriv = false;
        }
        return hasPriv;
    }

    public Boolean hasPartitionColumns() {
        return this.hasPasswordPolicy();
    }

    public Boolean hasPriorityGroups() {
        return this.getAtLeastV6() != false && this.getMinorVersion() >= 1 && this.getMajorVersion() < 7;
    }

    public Boolean hasPasswordPolicy() {
        return this.getAtLeastV6() != false && this.getMinorVersion() >= 1 || this.getMajorVersion() >= 7;
    }

    public Boolean hasConsumerGroups() {
        return this.getMajorVersion() >= 7;
    }
}

