/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBAbstractUser;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class IoTDBRelationalUser
extends IoTDBAbstractUser {
    private static final Log log = Log.getLog(IoTDBRelationalUser.class);
    private List<IoTDBDatabase> databases;
    private IoTDBDatabase allDatabase;

    public IoTDBRelationalUser(IoTDBDataSource dataSource, String userName, DBRProgressMonitor monitor) throws DBException {
        super(dataSource, userName);
        try {
            if (dataSource.isTable()) {
                this.loadDatabases(monitor);
            } else {
                this.loadTreeDatabasesAndDevices(monitor);
            }
        }
        catch (DBException e) {
            log.error((Object)"Error loading databases and tables", (Throwable)e);
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
    }

    public IoTDBDatabase getDatabaseAll() {
        if (this.allDatabase == null) {
            ArrayList<String> tables = new ArrayList<String>();
            tables.add("(ALL)");
            this.allDatabase = new IoTDBDatabase("(ALL)", tables);
        }
        return this.allDatabase;
    }

    public List<IoTDBDatabase> getDatabases() {
        return this.databases;
    }

    public void loadDatabases(DBRProgressMonitor monitor) throws DBException {
        block33: {
            this.databases = new ArrayList<IoTDBDatabase>();
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load Databases and Tables Info");){
                Object sql = "show databases";
                try (JDBCStatement stmt = session.createStatement();
                     JDBCResultSet rs = stmt.executeQuery((String)sql);){
                    if (rs == null) break block33;
                    while (rs.next()) {
                        String currentDatabase = rs.getString("Database");
                        ArrayList<String> currentTables = new ArrayList<String>();
                        sql = "show tables in " + DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)currentDatabase, (boolean)true, (boolean)true);
                        JDBCStatement stmt2 = session.createStatement();
                        try {
                            JDBCResultSet rs2 = stmt2.executeQuery((String)sql);
                            try {
                                if (rs2 != null) {
                                    while (rs2.next()) {
                                        currentTables.add(rs2.getString("TableName"));
                                    }
                                }
                                IoTDBDatabase newDatabase = new IoTDBDatabase(currentDatabase, currentTables);
                                this.databases.add(newDatabase);
                            }
                            finally {
                                if (rs2 == null) continue;
                                rs2.close();
                            }
                        }
                        finally {
                            if (stmt2 == null) continue;
                            stmt2.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Error loading databases and tables", (Throwable)e);
            }
        }
    }

    public void loadTreeDatabasesAndDevices(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.databases = new ArrayList<IoTDBDatabase>();
        HashMap<String, List> databaseDevicesMap = new HashMap<String, List>();
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load Databases and Tables Info");
             JDBCStatement stmt = session.createStatement();
             JDBCResultSet rs = stmt.executeQuery("show devices root.** with database");){
            while (rs.next()) {
                String currentDatabase = rs.getString("Database");
                int prefixLength = currentDatabase.length() + 1;
                String currentTableName = rs.getString("Device").substring(prefixLength);
                databaseDevicesMap.computeIfAbsent(currentDatabase, ignored -> new ArrayList()).add(currentTableName);
            }
            for (Map.Entry entry : databaseDevicesMap.entrySet()) {
                IoTDBDatabase newDatabase = new IoTDBDatabase((String)entry.getKey(), (List)entry.getValue());
                this.databases.add(newDatabase);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading databases and tables in tree model", (Throwable)e);
        }
    }

    public static class IoTDBDatabase {
        public final String name;
        public final List<String> tables;

        public IoTDBDatabase(String name, List<String> tables) {
            this.name = name;
            this.tables = tables;
        }
    }
}

