/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.informix;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class InformixUtils {
    static final Log log = Log.getLog(InformixUtils.class);

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<String> getSource(DBRProgressMonitor monitor, String sqlStatement, String dbObjectName, GenericDataSource datasource) throws DBException {
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)datasource, (String)"Load source code");){
            ArrayList<String> arrayList;
            block23: {
                JDBCPreparedStatement dbStat = session.prepareStatement(sqlStatement);
                try {
                    ArrayList<String> result = new ArrayList<String>();
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        boolean firstPart = true;
                        while (dbResult.nextRow()) {
                            Object procBodyPart = dbResult.getString(1);
                            if (((String)procBodyPart).startsWith("create") && !firstPart) {
                                procBodyPart = "\n" + (String)procBodyPart;
                            }
                            firstPart = false;
                            result.add((String)procBodyPart);
                        }
                    }
                    arrayList = result;
                    if (dbStat == null) break block23;
                }
                catch (Throwable throwable) {
                    if (dbStat != null) {
                        try {
                            dbStat.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dbStat.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            throw new DBException("Can't read source code of '" + dbObjectName + "'", (Throwable)e);
        }
    }

    public static String listToString(List<String> value, String delimiter) {
        StringBuilder sbResult = new StringBuilder();
        for (String o : value) {
            sbResult.append(o);
            if (delimiter == null || delimiter.isEmpty()) continue;
            sbResult.append(delimiter);
        }
        return sbResult.toString();
    }

    public static String getProcedureSource(DBRProgressMonitor monitor, GenericProcedure procedure) throws DBException {
        String sqlProcedure = String.format("select b.data from sysprocbody b join sysprocedures p on b.procid=p.procid where datakey='T' and p.procname = '%s'order by b.procid, b.seqno", procedure.getName());
        return InformixUtils.listToString(InformixUtils.getSource(monitor, sqlProcedure, procedure.getName(), (GenericDataSource)procedure.getDataSource()), null);
    }

    public static String getViewSource(DBRProgressMonitor monitor, GenericTableBase view) throws DBException {
        String sqlView = String.format("select v.viewtext from informix.sysviews v join systables s on s.tabid = v.tabid where s.tabname = '%s'", view.getName());
        return InformixUtils.listToString(InformixUtils.getSource(monitor, sqlView, view.getName(), (GenericDataSource)view.getDataSource()), null);
    }

    public static String getTriggerDDL(DBRProgressMonitor monitor, GenericTableBase table) throws DBException {
        String sqlTrigger = String.format("select tb.data from systables ta join systriggers tr on tr.tabid = ta.tabid join systrigbody tb on tb.trigid = tr.trigid where ta.tabname = '%s' and ta.tabtype='T' and tb.datakey IN ('A', 'D') order by tr.trigname, datakey desc, seqno ", table.getName());
        return InformixUtils.listToString(InformixUtils.getSource(monitor, sqlTrigger, table.getName(), (GenericDataSource)table.getDataSource()), "\n");
    }

    public static String getTriggerDDL(DBRProgressMonitor monitor, GenericTrigger trigger) throws DBException {
        assert (trigger.getTable() != null);
        String sqlTrigger = String.format("select tb.data from systables ta join systriggers tr on tr.tabid = ta.tabid join systrigbody tb on tb.trigid = tr.trigid where ta.tabname = '%s' and ta.tabtype='T' and tb.datakey IN ('A', 'D') and tr.trigname = '%s'order by tr.trigname, datakey desc, seqno ", trigger.getTable().getName(), trigger.getName());
        return InformixUtils.listToString(InformixUtils.getSource(monitor, sqlTrigger, trigger.getName(), trigger.getDataSource()), "\n");
    }
}

