/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetSorter;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.runtime.properties.ILazyPropertyLoadListener;
import org.jkiss.dbeaver.runtime.properties.PropertiesContributor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCollection;
import org.jkiss.dbeaver.runtime.properties.PropertySourceMap;
import org.jkiss.dbeaver.ui.properties.PropertySourceDelegate;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;

public class PropertyPageStandard
extends PropertySheetPage
implements ILazyPropertyLoadListener,
IPropertySourceProvider {
    private PropertySourceCache[] curSelection = null;

    public PropertyPageStandard() {
        this.setSorter(new PropertySheetSorter(this){

            public int compare(IPropertySheetEntry entryA, IPropertySheetEntry entryB) {
                return 0;
            }
        });
        this.setPropertySourceProvider(this);
        PropertiesContributor.getInstance().addLazyListener((ILazyPropertyLoadListener)this);
    }

    public void dispose() {
        PropertiesContributor.getInstance().removeLazyListener((ILazyPropertyLoadListener)this);
        super.dispose();
    }

    public void handlePropertyLoad(Object object, DBPPropertyDescriptor property, Object propertyValue, boolean completed) {
        if (!ArrayUtils.isEmpty((Object[])this.curSelection) && !this.getControl().isDisposed()) {
            for (PropertySourceCache cache : this.curSelection) {
                if ((cache.propertySource == null || cache.propertySource.getEditableValue() != object) && cache.object != object) continue;
                this.refresh();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            this.curSelection = new PropertySourceCache[ss.size()];
            if (ss.size() == 1) {
                this.curSelection[0] = new PropertySourceCache(ss.getFirstElement());
            } else {
                int index = 0;
                Iterator iter = ss.iterator();
                while (iter.hasNext()) {
                    this.curSelection[index++] = new PropertySourceCache(iter.next());
                }
            }
        }
        this.getControl().setRedraw(false);
        try {
            super.selectionChanged(part, selection);
        }
        finally {
            this.getControl().setRedraw(true);
        }
    }

    public IPropertySource getPropertySource(Object object) {
        if (object == null || object.getClass().isPrimitive() || object instanceof CharSequence || object instanceof Number || object instanceof Boolean) {
            return null;
        }
        if (!ArrayUtils.isEmpty((Object[])this.curSelection)) {
            for (PropertySourceCache cache : this.curSelection) {
                if (cache.object != object) continue;
                if (!cache.cached) {
                    if (object instanceof IAdaptable) {
                        cache.propertySource = (IPropertySource)((IAdaptable)object).getAdapter(IPropertySource.class);
                    }
                    if (cache.propertySource == null) {
                        cache.propertySource = (IPropertySource)RuntimeUtils.getObjectAdapter((Object)object, IPropertySource.class);
                    }
                    cache.cached = true;
                }
                return cache.propertySource;
            }
        }
        if (object instanceof Collection) {
            return new PropertySourceDelegate((DBPPropertySource)new PropertySourceCollection((Collection)object));
        }
        if (object instanceof Map) {
            return new PropertySourceDelegate((DBPPropertySource)new PropertySourceMap((Map)object));
        }
        return (IPropertySource)RuntimeUtils.getObjectAdapter((Object)object, IPropertySource.class);
    }

    private static class PropertySourceCache {
        Object object;
        IPropertySource propertySource;
        boolean cached;

        public PropertySourceCache(Object object) {
            this.object = object instanceof IPropertySource ? ((IPropertySource)object).getEditableValue() : object;
        }
    }
}

