/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.confirmation.ConfirmationDescriptor;
import org.jkiss.dbeaver.registry.confirmation.ConfirmationRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIActivator;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public class ConfirmationDialog
extends MessageDialogWithToggle {
    private static final Log log = Log.getLog(UIStyles.class);
    public static final int CONFIRM_WITH_YES_TO_ALL = 7;
    private final boolean hideToggle;

    public ConfirmationDialog(Shell parentShell, String dialogTitle, Image image, String message, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String toggleMessage, boolean toggleState) {
        super(parentShell, dialogTitle, image, message, dialogImageType, dialogButtonLabels, defaultIndex, toggleMessage, toggleState);
        this.hideToggle = toggleMessage == null;
    }

    protected Control createDialogArea(Composite parent) {
        Control dialogArea = super.createDialogArea(parent);
        if (this.hideToggle) {
            this.getToggleButton().setVisible(false);
        }
        return dialogArea;
    }

    protected void initializeBounds() {
        super.initializeBounds();
    }

    @Nullable
    public static Boolean getPersistedState(@NotNull String id, int kind) {
        String key = "org.jkiss.dbeaver.core.confirm." + id;
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        if ("always".equals(store.getString(key))) {
            return true;
        }
        if ("never".equals(store.getString(key))) {
            return kind != 3 && kind != 6;
        }
        return null;
    }

    public static int open(int kind, int imageKind, Shell parent, String title, String message, String toggleMessage, boolean toggleState, String key) {
        DBPPreferenceStore prefStore = DBWorkbench.getPlatform().getPreferenceStore();
        if (toggleMessage != null) {
            if ("always".equals(prefStore.getString(key))) {
                if (kind == 3 || kind == 6) {
                    return 2;
                }
                return 0;
            }
            if ("never".equals(prefStore.getString(key))) {
                if (kind == 3 || kind == 6) {
                    return 3;
                }
                return 0;
            }
        }
        ConfirmationDialog dialog = new ConfirmationDialog(parent == null ? UIUtils.getActiveWorkbenchShell() : parent, title, null, message, imageKind, ConfirmationDialog.getButtonLabels(kind), ConfirmationDialog.getDefaultIndex(kind, imageKind), toggleMessage, toggleState);
        dialog.setPrefStore(new PreferenceStoreDelegate(prefStore));
        dialog.setPrefKey(key);
        return dialog.open();
    }

    public static String[] getButtonLabels(int kind) {
        String[] stringArray;
        switch (kind) {
            case 1: 
            case 2: 
            case 4: {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = IDialogConstants.OK_LABEL;
                break;
            }
            case 5: {
                if (RuntimeUtils.isMacOS()) {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = IDialogConstants.CANCEL_LABEL;
                    stringArray = stringArray3;
                    stringArray3[1] = IDialogConstants.OK_LABEL;
                    break;
                }
                String[] stringArray4 = new String[2];
                stringArray4[0] = IDialogConstants.OK_LABEL;
                stringArray = stringArray4;
                stringArray4[1] = IDialogConstants.CANCEL_LABEL;
                break;
            }
            case 3: {
                if (RuntimeUtils.isMacOS()) {
                    String[] stringArray5 = new String[2];
                    stringArray5[0] = IDialogConstants.NO_LABEL;
                    stringArray = stringArray5;
                    stringArray5[1] = IDialogConstants.YES_LABEL;
                    break;
                }
                String[] stringArray6 = new String[2];
                stringArray6[0] = IDialogConstants.YES_LABEL;
                stringArray = stringArray6;
                stringArray6[1] = IDialogConstants.NO_LABEL;
                break;
            }
            case 6: {
                if (RuntimeUtils.isMacOS()) {
                    String[] stringArray7 = new String[3];
                    stringArray7[0] = IDialogConstants.CANCEL_LABEL;
                    stringArray7[1] = IDialogConstants.NO_LABEL;
                    stringArray = stringArray7;
                    stringArray7[2] = IDialogConstants.YES_LABEL;
                    break;
                }
                String[] stringArray8 = new String[3];
                stringArray8[0] = IDialogConstants.YES_LABEL;
                stringArray8[1] = IDialogConstants.NO_LABEL;
                stringArray = stringArray8;
                stringArray8[2] = IDialogConstants.CANCEL_LABEL;
                break;
            }
            case 7: {
                if (RuntimeUtils.isMacOS()) {
                    String[] stringArray9 = new String[3];
                    stringArray9[0] = IDialogConstants.CANCEL_LABEL;
                    stringArray9[1] = IDialogConstants.OK_LABEL;
                    stringArray = stringArray9;
                    stringArray9[2] = IDialogConstants.YES_TO_ALL_LABEL;
                    break;
                }
                String[] stringArray10 = new String[3];
                stringArray10[0] = IDialogConstants.YES_TO_ALL_LABEL;
                stringArray10[1] = IDialogConstants.OK_LABEL;
                stringArray = stringArray10;
                stringArray10[2] = IDialogConstants.CANCEL_LABEL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for kind in MessageDialog.open()");
            }
        }
        return stringArray;
    }

    public static int getDefaultIndex(int kind, int imageKind) {
        switch (kind) {
            case 1: 
            case 2: 
            case 4: {
                return 0;
            }
            case 5: {
                if (imageKind == 4) {
                    return RuntimeUtils.isMacOS() ? 0 : 1;
                }
                return RuntimeUtils.isMacOS() ? 1 : 0;
            }
            case 3: {
                return RuntimeUtils.isMacOS() ? 0 : 1;
            }
            case 6: 
            case 7: {
                return RuntimeUtils.isMacOS() ? 0 : 2;
            }
        }
        throw new IllegalArgumentException("Illegal value for kind in MessageDialog.open()");
    }

    public static int confirmAction(@Nullable Shell shell, @NotNull String id, int type, Object ... args) {
        return ConfirmationDialog.confirmAction(shell, -1, id, type, args);
    }

    public static int confirmAction(@Nullable Shell shell, int imageType, @NotNull String id, int type, Object ... args) {
        ConfirmationDescriptor descriptor = ConfirmationRegistry.getInstance().getConfirmation(id);
        String toggleMessage = descriptor.getToggleMessage();
        if ("default".equals(descriptor.getToggleMessage())) {
            ResourceBundle resourceBundle = RuntimeUtils.getBundleLocalization((Bundle)UIActivator.getDefault().getBundle(), (String)Locale.getDefault().getLanguage());
            try {
                toggleMessage = resourceBundle.getString("confirm.general.toggleMessage");
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        return ConfirmationDialog.open(type, imageType == -1 ? type : imageType, shell, NLS.bind((String)descriptor.getTitle(), (Object[])args), NLS.bind((String)descriptor.getMessage(), (Object[])args), toggleMessage != null ? NLS.bind((String)toggleMessage, (Object[])args) : null, false, "org.jkiss.dbeaver.core.confirm." + id);
    }

    public static String getSavedPreference(String id) {
        DBPPreferenceStore prefStore = DBWorkbench.getPlatform().getPreferenceStore();
        return prefStore.getString("org.jkiss.dbeaver.core.confirm." + id);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        IPreferenceStore prefStore = this.getPrefStore();
        String prefKey = this.getPrefKey();
        if (buttonId != 1 && this.getToggleState() && prefStore != null && CommonUtils.isNotEmpty((String)prefKey)) {
            if (buttonId == 3) {
                prefStore.setValue(prefKey, "never");
            } else {
                prefStore.setValue(prefKey, "always");
            }
        }
    }
}

