/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core.rule.describe;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.NestedModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;

@ThreadSafe
abstract class AbstractModelRuleDescriptor
implements ModelRuleDescriptor {
    protected static final StringInterner STRING_INTERNER = new StringInterner();

    AbstractModelRuleDescriptor() {
    }

    @Override
    public ModelRuleDescriptor append(ModelRuleDescriptor child) {
        return new NestedModelRuleDescriptor(this, child);
    }

    @Override
    public ModelRuleDescriptor append(String child) {
        return this.append(new SimpleModelRuleDescriptor(child));
    }

    @Override
    @FormatMethod
    public ModelRuleDescriptor append(@FormatString String child, Object ... args) {
        return this.append(String.format(child, args));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.describeTo(sb);
        return sb.toString();
    }
}

