/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.common.Nullable;
import org.opensearch.common.util.concurrent.ListenableFuture;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.seqno.LocalCheckpointTracker;

public class ReplicationRequestTracker {
    private final Map<Long, ListenableFuture<Void>> ongoingRequests = Collections.synchronizedMap(new HashMap());
    private final LocalCheckpointTracker checkpointTracker = new LocalCheckpointTracker(-1L, -1L);

    @Nullable
    public synchronized ActionListener<Void> markReceivedAndCreateListener(final long requestSeqNo, final ActionListener<Void> listener) {
        if (this.checkpointTracker.hasProcessed(requestSeqNo)) {
            ListenableFuture<Void> existingFuture = this.ongoingRequests.get(requestSeqNo);
            if (existingFuture != null) {
                existingFuture.addListener(listener, OpenSearchExecutors.newDirectExecutorService());
            } else {
                listener.onResponse(null);
            }
            return null;
        }
        this.checkpointTracker.markSeqNoAsProcessed(requestSeqNo);
        ListenableFuture<Void> future = new ListenableFuture<Void>();
        this.ongoingRequests.put(requestSeqNo, future);
        future.addListener(new ActionListener<Void>(){

            public void onResponse(Void v) {
                ReplicationRequestTracker.this.ongoingRequests.remove(requestSeqNo);
                listener.onResponse((Object)v);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, OpenSearchExecutors.newDirectExecutorService());
        return future;
    }
}

